<?php
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
if (file_exists(__DIR__ . '/controller_additions.php')) require_once __DIR__ . '/controller_additions.php';
require_once dirname(__DIR__, 2) . '/app/logger.php';
require_once dirname(__DIR__, 2) . '/app/audit.php';

/**
 * Совместимый способ получить last insert id без зависимости от db_last_id().
 * В проекте есть db() (mysqli соединение), поэтому берём mysqli_insert_id().
 */
if (!function_exists('settings_last_id')) {
function settings_last_id() {
    $conn = db();
    return $conn ? (int)mysqli_insert_id($conn) : 0;
}
}

function settings_users() {
    $u = require_role(['admin','director']);

    $role = trim($_GET['role'] ?? '');
    $location_id = (int)($_GET['location_id'] ?? 0);

    $where = "1=1";
    if ($role !== '') {
        $role_esc = db_escape($role);
        $where .= " AND u.role='$role_esc'";
    }
    if ($location_id > 0) {
        $where .= " AND EXISTS (SELECT 1 FROM user_locations ul WHERE ul.user_id=u.id AND ul.location_id=$location_id)";
    }

    $users = db_fetch_all(db_query("SELECT u.* FROM users u WHERE $where ORDER BY u.full_name"));

    $roles = ['admin'=>'Администратор','director'=>'Директор','prod_head'=>'Начальник производства','brigadier'=>'Бригадир','otk'=>'ОТК','storekeeper'=>'Кладовщик'];
    $locations = db_fetch_all(db_query("SELECT * FROM locations ORDER BY name"));

    render('settings/users_list', [
        'u' => $u,
        'users' => $users,
        'roles' => $roles,
        'locations' => $locations,
        'filter_role' => $role,
        'filter_location_id' => $location_id,
    ]);
}

function settings_user_edit() {
    $u = require_role(['admin','director']);

    $id = (int)($_GET['id'] ?? 0);
    $roles = ['admin'=>'Администратор','director'=>'Директор','prod_head'=>'Начальник производства','brigadier'=>'Бригадир','otk'=>'ОТК','storekeeper'=>'Кладовщик'];
    $locations = db_fetch_all(db_query("SELECT * FROM locations ORDER BY name"));

    $item = null;
    $selected_locations = [];

    if ($id > 0) {
        $item = db_fetch_one(db_query("SELECT * FROM users WHERE id=$id LIMIT 1"));
        $locs = db_fetch_all(db_query("SELECT location_id FROM user_locations WHERE user_id=$id"));
        foreach ($locs as $r) $selected_locations[] = (int)$r['location_id'];
        if (!$item) { http_response_code(404); echo "Пользователь не найден"; exit; }
    }

    $msg = '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $login = trim($_POST['login'] ?? '');
        $full_name = trim($_POST['full_name'] ?? '');
        $position = trim($_POST['position'] ?? '');
        $role = trim($_POST['role'] ?? '');
        $telegram_id = trim($_POST['telegram_id'] ?? '');
        $is_active = isset($_POST['is_active']) ? 1 : 0;
        $password = (string)($_POST['password'] ?? '');
        $loc_ids = $_POST['locations'] ?? [];

        if ($login === '' || $full_name === '' || $role === '') {
            $msg = 'Заполните обязательные поля: логин, ФИО, роль';
        } else {
            $login_esc = db_escape($login);
            $full_esc = db_escape($full_name);
            $pos_esc = db_escape($position);
            $role_esc = db_escape($role);
            $tg_esc = db_escape($telegram_id);

            if ($id > 0) {
                db_query("UPDATE users SET login='$login_esc', full_name='$full_esc', position='$pos_esc', role='$role_esc', telegram_id='$tg_esc', is_active=$is_active WHERE id=$id");
                log_info('USER_UPDATE', ['by'=>(int)$u['id'],'user_id'=>$id]);
                audit('UPDATE','users',$id,(int)$u['id'], ['login'=>$login,'full_name'=>$full_name,'role'=>$role]);

                if ($password !== '') {
                    $hash = db_escape(password_hash_simple($password));
                    db_query("UPDATE users SET password_hash='$hash' WHERE id=$id");
                    log_info('USER_PASS_CHANGE', ['by'=>(int)$u['id'],'user_id'=>$id]);
                    audit('UPDATE','users',$id,(int)$u['id'], ['password_changed'=>true]);
                }

                db_query("DELETE FROM user_locations WHERE user_id=$id");
                foreach ($loc_ids as $lid) {
                    $lid = (int)$lid;
                    if ($lid > 0) db_query("INSERT INTO user_locations(user_id, location_id) VALUES ($id, $lid)");
                }
                header('Location: index.php?m=settings&a=users');
                exit;
            } else {
                if ($password === '') $password = 'admin123';
                $hash = db_escape(password_hash_simple($password));
                db_query("INSERT INTO users(login,password_hash,full_name,position,role,telegram_id,is_active,created_at) 
                          VALUES ('$login_esc','$hash','$full_esc','$pos_esc','$role_esc','$tg_esc',$is_active,NOW())");
                $new_id = settings_last_id(); // FIX: было db_last_id()
                log_info('USER_CREATE', ['by'=>(int)$u['id'],'user_id'=>$new_id]);
                audit('CREATE','users',$new_id,(int)$u['id'], ['login'=>$login,'full_name'=>$full_name,'role'=>$role]);

                foreach ($loc_ids as $lid) {
                    $lid = (int)$lid;
                    if ($lid > 0) db_query("INSERT INTO user_locations(user_id, location_id) VALUES ($new_id, $lid)");
                }
                header('Location: index.php?m=settings&a=users');
                exit;
            }
        }
        $item = ['id'=>$id,'login'=>$login,'full_name'=>$full_name,'position'=>$position,'role'=>$role,'telegram_id'=>$telegram_id,'is_active'=>$is_active];
        $selected_locations = array_map('intval', (array)$loc_ids);
    }

    render('settings/user_edit', [
        'u'=>$u, 'item'=>$item, 'roles'=>$roles, 'locations'=>$locations, 'selected_locations'=>$selected_locations, 'msg'=>$msg
    ]);
}

function settings_user_delete() {
    $u = require_role(['admin','director']);
    $id = (int)($_GET['id'] ?? 0);
    if ($id <= 0) { header('Location: index.php?m=settings&a=users'); exit; }
    if ((int)$u['id'] === $id) { header('Location: index.php?m=settings&a=users'); exit; }

    db_query("DELETE FROM user_locations WHERE user_id=$id");
    db_query("DELETE FROM users WHERE id=$id");
    log_info('USER_DELETE', ['by'=>(int)$u['id'],'user_id'=>$id]);
    audit('DELETE','users',$id,(int)$u['id'], null);
    header('Location: index.php?m=settings&a=users');
    exit;
}

function settings_locations() {
    $u = require_role(['admin','director']);
    $locations = db_fetch_all(db_query("SELECT * FROM locations ORDER BY name"));
    $workshops = db_fetch_all(db_query("SELECT w.*, l.name AS location_name FROM workshops w JOIN locations l ON l.id=w.location_id ORDER BY l.name, w.name"));

    render('settings/locations', ['u'=>$u,'locations'=>$locations,'workshops'=>$workshops]);
}

function settings_location_edit() {
    $u = require_role(['admin','director']);
    $id = (int)($_GET['id'] ?? 0);
    $item = null;
    if ($id > 0) $item = db_fetch_one(db_query("SELECT * FROM locations WHERE id=$id LIMIT 1"));

    $msg = '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $name = trim($_POST['name'] ?? '');
        if ($name === '') $msg = 'Название обязательно';
        else {
            $name_esc = db_escape($name);
            if ($id > 0) {
                db_query("UPDATE locations SET name='$name_esc' WHERE id=$id");
                log_info('LOCATION_UPDATE', ['by'=>(int)$u['id'],'id'=>$id]);
                audit('UPDATE','locations',$id,(int)$u['id'], ['name'=>$name]);
            } else {
                db_query("INSERT INTO locations(name) VALUES ('$name_esc')");
                $nid = settings_last_id(); // FIX
                log_info('LOCATION_CREATE', ['by'=>(int)$u['id'],'id'=>$nid]);
                audit('CREATE','locations',$nid,(int)$u['id'], ['name'=>$name]);
            }
            header('Location: index.php?m=settings&a=locations');
            exit;
        }
        $item = ['id'=>$id,'name'=>$name];
    }

    render('settings/location_edit', ['u'=>$u,'item'=>$item,'msg'=>$msg]);
}

function settings_workshop_edit() {
    $u = require_role(['admin','director']);
    $id = (int)($_GET['id'] ?? 0);
    $item = null;
    if ($id > 0) $item = db_fetch_one(db_query("SELECT * FROM workshops WHERE id=$id LIMIT 1"));

    $locations = db_fetch_all(db_query("SELECT * FROM locations ORDER BY name"));
    $msg = '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $name = trim($_POST['name'] ?? '');
        $location_id = (int)($_POST['location_id'] ?? 0);

        if ($name === '' || $location_id <= 0) $msg = 'Название и локация обязательны';
        else {
            $name_esc = db_escape($name);
            if ($id > 0) {
                db_query("UPDATE workshops SET name='$name_esc', location_id=$location_id WHERE id=$id");
                log_info('WORKSHOP_UPDATE', ['by'=>(int)$u['id'],'id'=>$id]);
                audit('UPDATE','workshops',$id,(int)$u['id'], ['name'=>$name,'location_id'=>$location_id]);
            } else {
                db_query("INSERT INTO workshops(name, location_id) VALUES ('$name_esc',$location_id)");
                $nid = settings_last_id(); // FIX
                log_info('WORKSHOP_CREATE', ['by'=>(int)$u['id'],'id'=>$nid]);
                audit('CREATE','workshops',$nid,(int)$u['id'], ['name'=>$name,'location_id'=>$location_id]);
            }
            header('Location: index.php?m=settings&a=locations');
            exit;
        }
        $item = ['id'=>$id,'name'=>$name,'location_id'=>$location_id];
    }

    render('settings/workshop_edit', ['u'=>$u,'item'=>$item,'locations'=>$locations,'msg'=>$msg]);
}

/* ===== Категории материалов ===== */

function settings_material_categories() {
    $u = require_role(['admin','director']);

    $cats = db_fetch_all(db_query("SELECT * FROM material_categories ORDER BY name"));
    render('settings/material_categories_list', ['u'=>$u,'cats'=>$cats]);
}

function settings_material_category_edit() {
    $u = require_role(['admin','director']);
    $id = (int)($_GET['id'] ?? 0);
    $item = null;
    if ($id > 0) $item = db_fetch_one(db_query("SELECT * FROM material_categories WHERE id=$id LIMIT 1"));

    $msg = '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $name = trim($_POST['name'] ?? '');
        $desc = trim($_POST['description'] ?? '');

        if ($name === '') $msg = 'Название обязательно';
        else {
            $name_esc = db_escape($name);
            $desc_esc = db_escape($desc);
            if ($id > 0) {
                db_query("UPDATE material_categories SET name='$name_esc', description='$desc_esc' WHERE id=$id");
                audit('UPDATE','material_categories',$id,(int)$u['id'], ['name'=>$name]);
            } else {
                db_query("INSERT INTO material_categories(name, description) VALUES ('$name_esc', '$desc_esc')");
                $nid = settings_last_id(); // FIX
                audit('CREATE','material_categories',$nid,(int)$u['id'], ['name'=>$name]);
            }
            header('Location: index.php?m=settings&a=material_categories');
            exit;
        }
        $item = ['id'=>$id,'name'=>$name,'description'=>$desc];
    }

    render('settings/material_category_edit', ['u'=>$u,'item'=>$item,'msg'=>$msg]);
}

function settings_material_category_delete() {
    $u = require_role(['admin','director']);
    $id = (int)($_GET['id'] ?? 0);
    if ($id <= 0) { header('Location: index.php?m=settings&a=material_categories'); exit; }

    db_query("DELETE FROM material_categories WHERE id=$id");
    audit('DELETE','material_categories',$id,(int)$u['id'], null);
    header('Location: index.php?m=settings&a=material_categories');
    exit;
}
