<?php
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
require_once dirname(__DIR__, 2) . '/app/finished_parts.php';

function production_finished_parts() {
    $u = require_role(['admin','director','prod_head','brigadier']);

    // Ограничения по локации/цеху: берем из профиля пользователя (как сделано в текущем проекте)
    $location_id = (int)($u['location_id'] ?? 0);
    $workshop_id = (int)($u['workshop_id'] ?? 0);

    // Для admin/director можно выбрать в форме
    if (in_array($u['role'], ['admin','director'], true)) {
        $location_id = (int)($_GET['location_id'] ?? $location_id);
        $workshop_id = (int)($_GET['workshop_id'] ?? $workshop_id);
    }

    if ($location_id<=0) {
        // подстраховка: возьмем первую локацию
        $l = db_fetch_one(db_query("SELECT id FROM locations ORDER BY name LIMIT 1"));
        if ($l) $location_id = (int)$l['id'];
    }

    $locations = db_fetch_all(db_query("SELECT id, name FROM locations ORDER BY name"));
    $workshops = ($location_id>0) ? db_fetch_all(db_query("SELECT id, name FROM workshops WHERE location_id=$location_id ORDER BY name")) : [];

    if ($workshop_id<=0 && count($workshops)>0) $workshop_id = (int)$workshops[0]['id'];

    // список деталей для выбранного цеха
    $parts = ($workshop_id>0) ? db_fetch_all(db_query("SELECT id, name FROM parts WHERE workshop_id=$workshop_id AND is_active=1 ORDER BY name")) : [];

    $msg = '';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $location_id = (int)($_POST['location_id'] ?? 0);
        $workshop_id = (int)($_POST['workshop_id'] ?? 0);
        $part_id = (int)($_POST['part_id'] ?? 0);
        $qty = str_replace(',', '.', trim($_POST['qty'] ?? '0'));
        $comment = trim($_POST['comment'] ?? '');

        if ($location_id<=0 || $workshop_id<=0 || $part_id<=0) $msg='Выберите локацию, цех и деталь';
        else if (!is_numeric($qty) || (float)$qty<=0) $msg='Количество должно быть больше 0';
        else {
            fp_add_in($location_id, $workshop_id, $part_id, (float)$qty, $comment, (int)$u['id']);
            header("Location: index.php?m=production&a=finished_parts&ok=1");
            exit;
        }
    }

    render('production/finished_parts', [
        'u'=>$u,
        'locations'=>$locations,
        'workshops'=>$workshops,
        'parts'=>$parts,
        'location_id'=>$location_id,
        'workshop_id'=>$workshop_id,
        'msg'=>$msg
    ]);
}

function production_finished_stock() {
    $u = require_role(['admin','director','prod_head','brigadier']);

    $location_id = (int)($u['location_id'] ?? 0);
    $workshop_id = (int)($u['workshop_id'] ?? 0);

    if (in_array($u['role'], ['admin','director'], true)) {
        $location_id = (int)($_GET['location_id'] ?? $location_id);
        $workshop_id = (int)($_GET['workshop_id'] ?? $workshop_id);
    }

    $locations = db_fetch_all(db_query("SELECT id, name FROM locations ORDER BY name"));
    if ($location_id<=0) {
        $l = db_fetch_one(db_query("SELECT id FROM locations ORDER BY name LIMIT 1"));
        if ($l) $location_id = (int)$l['id'];
    }

    $workshops = ($location_id>0) ? db_fetch_all(db_query("SELECT id, name FROM workshops WHERE location_id=$location_id ORDER BY name")) : [];
    if ($workshop_id<=0 && count($workshops)>0) $workshop_id = (int)$workshops[0]['id'];

    $rows = [];
    if ($location_id>0 && $workshop_id>0) {
        $rows = fp_list_balances_by_workshop($location_id, $workshop_id);
    }

    $employees = ($location_id>0) ? db_fetch_all(db_query("SELECT id, full_name FROM employees WHERE location_id=$location_id ORDER BY full_name")) : [];

    $err = $_GET['err'] ?? '';
    $ok = $_GET['ok'] ?? '';

    render('production/finished_stock', [
        'u'=>$u,
        'locations'=>$locations,
        'workshops'=>$workshops,
        'location_id'=>$location_id,
        'workshop_id'=>$workshop_id,
        'rows'=>$rows,
        'employees'=>$employees,
        'err'=>$err,
        'ok'=>$ok
    ]);
}

function production_finished_issue() {
    $u = require_role(['admin','director','prod_head','brigadier']);

    $location_id = (int)($_POST['location_id'] ?? 0);
    $from_workshop_id = (int)($_POST['from_workshop_id'] ?? 0);
    $part_id = (int)($_POST['part_id'] ?? 0);
    $qty = str_replace(',', '.', trim($_POST['qty'] ?? '0'));
    $to_type = $_POST['to_type'] ?? 'workshop';
    $to_id = (int)($_POST['to_id'] ?? 0);
    $comment = trim($_POST['comment'] ?? '');

    if ($location_id<=0 || $from_workshop_id<=0 || $part_id<=0) {
        header("Location: index.php?m=production&a=finished_stock&err=req");
        exit;
    }
    if (!is_numeric($qty) || (float)$qty<=0) {
        header("Location: index.php?m=production&a=finished_stock&location_id=$location_id&workshop_id=$from_workshop_id&err=qty");
        exit;
    }
    if ($to_id<=0) {
        header("Location: index.php?m=production&a=finished_stock&location_id=$location_id&workshop_id=$from_workshop_id&err=to");
        exit;
    }

    $bal = fp_get_balance($location_id, $from_workshop_id, $part_id);
    if ((float)$qty > $bal) {
        header("Location: index.php?m=production&a=finished_stock&location_id=$location_id&workshop_id=$from_workshop_id&err=bal");
        exit;
    }

    fp_issue($location_id, $from_workshop_id, $part_id, (float)$qty, $to_type, $to_id, $comment, (int)$u['id']);

    header("Location: index.php?m=production&a=finished_stock&location_id=$location_id&workshop_id=$from_workshop_id&ok=1");
    exit;
}
