<?php
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
require_once dirname(__DIR__, 2) . '/app/warehouse.php';
require_once dirname(__DIR__, 2) . '/app/audit.php';

function production_index() {
    // пока единственный подраздел
    header('Location: index.php?m=production&a=productivity');
    exit;
}

function production_productivity() {
    $u = require_role(['admin','director','prod_head','brigadier']);

    wh_ensure_places_exist();

    $locations = (in_array($u['role'], ['admin','director'], true))
        ? db_fetch_all(db_query("SELECT id AS location_id, name AS location_name FROM locations ORDER BY name"))
        : get_user_locations((int)$u['id']);

    $location_id = (int)($_GET['location_id'] ?? 0);
    if ($location_id===0 && count($locations)===1) $location_id=(int)$locations[0]['location_id'];
    if ($location_id>0 && !in_array($u['role'], ['admin','director'], true)) require_location_access((int)$u['id'], $location_id);

    $workshops = ($location_id>0) ? db_fetch_all(db_query("SELECT * FROM workshops WHERE location_id=$location_id ORDER BY name")) : [];
    $workshop_id = (int)($_GET['workshop_id'] ?? 0);
    $date = $_GET['date'] ?? date('Y-m-d');

    // списки для формы
    $employees = [];
    $operations = [];
    if ($location_id>0 && $workshop_id>0) {
        $employees = db_fetch_all(db_query("SELECT id, full_name FROM employees WHERE is_active=1 AND location_id=$location_id AND workshop_id=$workshop_id ORDER BY full_name"));
        $operations = db_fetch_all(db_query("SELECT id, name, price FROM operations WHERE is_active=1 AND workshop_id=$workshop_id ORDER BY name"));
    }

    $msg = '';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $work_date = trim($_POST['work_date'] ?? date('Y-m-d'));
        $location_id = (int)($_POST['location_id'] ?? 0);
        $workshop_id = (int)($_POST['workshop_id'] ?? 0);
        $employee_id = (int)($_POST['employee_id'] ?? 0);
        $operation_id = (int)($_POST['operation_id'] ?? 0);
        $qty = (int)($_POST['qty'] ?? 0);

        if ($location_id<=0 || $workshop_id<=0) $msg='Выберите локацию и цех';
        else if ($employee_id<=0 || $operation_id<=0) $msg='Выберите сотрудника и операцию';
        else if ($qty<=0) $msg='Количество должно быть больше 0';
        else {
            if (!in_array($u['role'], ['admin','director'], true)) require_location_access((int)$u['id'], $location_id);

            // проверим связь сотрудника/цеха
            $emp = db_fetch_one(db_query("SELECT * FROM employees WHERE id=$employee_id LIMIT 1"));
            if (!$emp || (int)$emp['location_id']!==$location_id || (int)$emp['workshop_id']!==$workshop_id) {
                $msg = 'Сотрудник не соответствует выбранной локации/цеху';
            } else {
                $op = db_fetch_one(db_query("SELECT * FROM operations WHERE id=$operation_id LIMIT 1"));
                if (!$op || (int)$op['workshop_id']!==$workshop_id) $msg='Операция не соответствует цеху';
                else {
                    // материалы/расходники по операции
                    $items = db_fetch_all(db_query("SELECT * FROM operation_items WHERE operation_id=$operation_id"));
                    $from_place = wh_get_place_id($location_id, 'workshop', $workshop_id);
                    if ($from_place<=0) $msg='Не найдено место хранения цеха (storage_places). Выполните миграцию склада.';
                    else {
                        // Транзакция: если не хватает — откат
                        db_query("START TRANSACTION");

                        // проверка остатков
                        $need = [];
                        foreach ($items as $it) {
                            $t = $it['item_type'];
                            $iid = (int)$it['item_id'];
                            $per = (float)$it['qty_per_op'];
                            $total = $per * $qty;
                            if ($total <= 0) continue;
                            $need[] = [$t,$iid,$total];
                            $bal = wh_get_balance($t, $iid, $from_place);
                            if ($bal < $total - 0.0001) {
                                $msg = "Недостаточно на складе цеха для списания. Не хватает: " . $total . " (доступно $bal).";
                                break;
                            }
                        }

                        if ($msg!=='') {
                            db_query("ROLLBACK");
                        } else {
                            $price = (float)$op['price'];
                            $amount = $price * $qty;

                            db_query("INSERT INTO production_logs(work_date,location_id,workshop_id,employee_id,operation_id,qty,price_at_time,amount,created_at,created_by)
                                      VALUES ('".db_escape($work_date)."',$location_id,$workshop_id,$employee_id,$operation_id,$qty,$price,$amount,NOW(),".(int)$u['id'].")");
                            $log_id = (int)db_last_id();
                            audit('CREATE','production_logs',$log_id,(int)$u['id'], ['work_date'=>$work_date,'qty'=>$qty,'operation_id'=>$operation_id]);

                            // списание материалов: stock_moves writeoff из цеха
                            foreach ($need as $n) {
                                [$t,$iid,$total] = $n;
                                wh_move_create([
                                    'item_type'=>$t,
                                    'item_id'=>$iid,
                                    'move_type'=>'writeoff',
                                    'from_place_id'=>$from_place,
                                    'to_place_id'=>null,
                                    'qty'=>$total,
                                    'reason'=>'Списание по операции: '.$op['name'],
                                    'comment'=>'Выработка #'.$log_id
                                ], (int)$u['id']);
                            }

                            db_query("COMMIT");
                            header("Location: index.php?m=production&a=productivity&location_id=$location_id&workshop_id=$workshop_id&date=".urlencode($work_date));
                            exit;
                        }
                    }
                }
            }
        }
    }

    // журнал за день
    $logs = [];
    if ($location_id>0) {
        $ws_filter = ($workshop_id>0) ? "AND pl.workshop_id=$workshop_id" : "";
        $d = db_escape($date);
        $logs = db_fetch_all(db_query("
          SELECT pl.*, e.full_name AS emp_name, o.name AS op_name, u2.full_name AS user_name
          FROM production_logs pl
          JOIN employees e ON e.id=pl.employee_id
          JOIN operations o ON o.id=pl.operation_id
          LEFT JOIN users u2 ON u2.id=pl.created_by
          WHERE pl.location_id=$location_id $ws_filter AND pl.work_date='$d'
          ORDER BY pl.id DESC
          LIMIT 200
        "));
    }

    render('production/productivity', [
        'u'=>$u,
        'locations'=>$locations,
        'location_id'=>$location_id,
        'workshops'=>$workshops,
        'workshop_id'=>$workshop_id,
        'employees'=>$employees,
        'operations'=>$operations,
        'date'=>$date,
        'logs'=>$logs,
        'msg'=>$msg
    ]);
}
