<?php
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
require_once dirname(__DIR__, 2) . '/app/xlsx.php';

function planfact_index() {
    // по умолчанию — детали
    planfact_parts();
}

function planfact_parts() {
    $u = require_role(['admin','director','prod_head','brigadier']);

    $today = date('Y-m-d');
    $from = $_GET['from'] ?? date('Y-m-01');
    $to = $_GET['to'] ?? $today;

    $location_id = (int)($_GET['location_id'] ?? 0);
    $workshop_id = (int)($_GET['workshop_id'] ?? 0);
    $part_id = (int)($_GET['part_id'] ?? 0);

    $export = (int)($_GET['export'] ?? 0);

    $locations = db_fetch_all(db_query("SELECT id, name FROM locations ORDER BY name"));
    if ($location_id<=0 && !empty($u['location_id'])) $location_id = (int)$u['location_id'];

    $workshops = ($location_id>0)
      ? db_fetch_all(db_query("SELECT id, name FROM workshops WHERE location_id=$location_id ORDER BY name"))
      : db_fetch_all(db_query("SELECT id, name FROM workshops ORDER BY name"));

    $parts = ($workshop_id>0)
      ? db_fetch_all(db_query("SELECT id, name FROM parts WHERE workshop_id=$workshop_id AND is_active=1 ORDER BY name"))
      : db_fetch_all(db_query("SELECT id, name FROM parts WHERE is_active=1 ORDER BY name"));

    $where = "q.is_deleted=0 AND q.qc_date>='".db_escape($from)."' AND q.qc_date<='".db_escape($to)."'";
    if ($location_id>0) $where .= " AND q.location_id=$location_id";
    if ($workshop_id>0) $where .= " AND q.workshop_id=$workshop_id";
    if ($part_id>0) $where .= " AND q.part_id=$part_id";

    // План: daily_plan (по детали), умножаем на количество рабочих дней периода? В ТЗ: "План/факт на текущую дату с начала месяца".
    // Для MVP: план берём как daily_plan * количество дней в периоде.
    $days = 1;
    $d1 = strtotime($from);
    $d2 = strtotime($to);
    if ($d1 && $d2 && $d2 >= $d1) {
        $days = (int)(($d2 - $d1) / 86400) + 1;
    }

    $rows = db_fetch_all(db_query("
      SELECT
        p.id AS part_id,
        p.name AS part_name,
        l.id AS location_id,
        l.name AS location_name,
        w.id AS workshop_id,
        w.name AS workshop_name,
        p.daily_plan AS daily_plan,
        COALESCE(SUM(q.good_qty),0) AS good_qty,
        COALESCE(SUM(q.bad_qty),0) AS bad_qty
      FROM parts p
      JOIN workshops w ON w.id=p.workshop_id
      JOIN locations l ON l.id=w.location_id
      LEFT JOIN qc_parts q ON q.part_id=p.id AND q.workshop_id=w.id AND q.location_id=l.id AND $where
      WHERE p.is_active=1
        ".($location_id>0 ? " AND l.id=$location_id" : "")."
        ".($workshop_id>0 ? " AND w.id=$workshop_id" : "")."
        ".($part_id>0 ? " AND p.id=$part_id" : "")."
      GROUP BY p.id, l.id, w.id
      ORDER BY l.name, w.name, p.name
    "));

    $out = [];
    foreach ($rows as $r) {
        $plan = (int)$r['daily_plan'] * $days;
        $good = (float)$r['good_qty'];
        $bad = (float)$r['bad_qty'];
        $fact = $good + $bad;
        $pct = ($plan>0) ? round(($good / $plan) * 100, 1) : 0;
        $out[] = [
            'part_name'=>$r['part_name'],
            'location_name'=>$r['location_name'],
            'workshop_name'=>$r['workshop_name'],
            'plan'=>$plan,
            'fact'=>$fact,
            'good'=>$good,
            'bad'=>$bad,
            'pct'=>$pct,
        ];
    }

    if ($export===1) {
        $table = [];
        $table[] = ['Деталь','Локация','Цех','План','Факт','Годных','Брак','% выполнения'];
        foreach ($out as $r) {
            $table[] = [$r['part_name'],$r['location_name'],$r['workshop_name'],$r['plan'],$r['fact'],$r['good'],$r['bad'],$r['pct']];
        }
        $fname = 'planfact_parts_'.date('Ymd_His').'.xlsx';
        xlsx_output($fname, $table, 'Детали');
    }

    render('planfact/parts', [
        'u'=>$u,
        'locations'=>$locations,
        'workshops'=>$workshops,
        'parts'=>$parts,
        'location_id'=>$location_id,
        'workshop_id'=>$workshop_id,
        'part_id'=>$part_id,
        'from'=>$from,
        'to'=>$to,
        'rows'=>$out,
        'days'=>$days,
    ]);
}

function planfact_operations() {
    $u = require_role(['admin','director','prod_head','brigadier']);

    $today = date('Y-m-d');
    $from = $_GET['from'] ?? date('Y-m-01');
    $to = $_GET['to'] ?? $today;

    $location_id = (int)($_GET['location_id'] ?? 0);
    $workshop_id = (int)($_GET['workshop_id'] ?? 0);
    $employee_id = (int)($_GET['employee_id'] ?? 0);
    $operation_id = (int)($_GET['operation_id'] ?? 0);

    $export = (int)($_GET['export'] ?? 0);

    $locations = db_fetch_all(db_query("SELECT id, name FROM locations ORDER BY name"));
    if ($location_id<=0 && !empty($u['location_id'])) $location_id = (int)$u['location_id'];

    $workshops = ($location_id>0)
      ? db_fetch_all(db_query("SELECT id, name FROM workshops WHERE location_id=$location_id ORDER BY name"))
      : db_fetch_all(db_query("SELECT id, name FROM workshops ORDER BY name"));

    $employees = ($workshop_id>0)
      ? db_fetch_all(db_query("SELECT id, full_name FROM employees WHERE workshop_id=$workshop_id AND is_active=1 ORDER BY full_name"))
      : db_fetch_all(db_query("SELECT id, full_name FROM employees WHERE is_active=1 ORDER BY full_name"));

    $operations = ($workshop_id>0)
      ? db_fetch_all(db_query("SELECT id, name, daily_plan_per_employee, workshop_id FROM operations WHERE workshop_id=$workshop_id AND is_active=1 ORDER BY name"))
      : db_fetch_all(db_query("SELECT id, name, daily_plan_per_employee, workshop_id FROM operations WHERE is_active=1 ORDER BY name"));

    // дни периода
    $days = 1;
    $d1 = strtotime($from);
    $d2 = strtotime($to);
    if ($d1 && $d2 && $d2 >= $d1) {
        $days = (int)(($d2 - $d1) / 86400) + 1;
    }

    // факты по выработке
    $where = "pl.work_date>='".db_escape($from)."' AND pl.work_date<='".db_escape($to)."'";
    if ($location_id>0) $where .= " AND pl.location_id=$location_id";
    if ($workshop_id>0) $where .= " AND pl.workshop_id=$workshop_id";
    if ($employee_id>0) $where .= " AND pl.employee_id=$employee_id";
    if ($operation_id>0) $where .= " AND pl.operation_id=$operation_id";

    $facts = db_fetch_all(db_query("
      SELECT pl.operation_id, pl.employee_id, SUM(pl.qty) AS qty
      FROM production_logs pl
      WHERE $where
      GROUP BY pl.operation_id, pl.employee_id
    "));

    $fact_map = [];
    foreach ($facts as $f) {
        $fact_map[(int)$f['operation_id'].'_'.(int)$f['employee_id']] = (int)$f['qty'];
    }

    // для плана нужно количество сотрудников (MVP: в цеху)
    $emp_count_by_ws = [];
    $emp_rows = db_fetch_all(db_query("SELECT workshop_id, COUNT(*) AS c FROM employees WHERE is_active=1 GROUP BY workshop_id"));
    foreach ($emp_rows as $er) $emp_count_by_ws[(int)$er['workshop_id']] = (int)$er['c'];

    $out = [];
    foreach ($facts as $f) {
        $opid = (int)$f['operation_id'];
        $eid = (int)$f['employee_id'];

        // найдём имена
        $op = null;
        foreach ($operations as $o) { if ((int)$o['id']===$opid) { $op=$o; break; } }
        if (!$op) continue;

        $emp = null;
        foreach ($employees as $e) { if ((int)$e['id']===$eid) { $emp=$e; break; } }
        if (!$emp && $employee_id>0) continue;

        $wsid = (int)$op['workshop_id'];
        $plan_emp = (int)$op['daily_plan_per_employee'] * $days;
        $plan = $plan_emp;
        if ($employee_id<=0) {
            $plan = $plan_emp * (int)($emp_count_by_ws[$wsid] ?? 1);
        }
        $fact = (int)$f['qty'];
        $pct = ($plan>0) ? round(($fact / $plan) * 100, 1) : 0;

        // локация/цех названия
        $ws_name = '';
        $loc_name = '';
        foreach ($workshops as $w) {
            if ((int)$w['id']===$wsid) { $ws_name=$w['name']; break; }
        }
        if ($wsid>0) {
            $lr = db_fetch_one(db_query("SELECT l.name AS loc_name FROM workshops w JOIN locations l ON l.id=w.location_id WHERE w.id=$wsid"));
            if ($lr) $loc_name = $lr['loc_name'];
        }

        $out[] = [
            'op_name'=>$op['name'],
            'emp_name'=>$emp ? $emp['full_name'] : '',
            'location_name'=>$loc_name,
            'workshop_name'=>$ws_name,
            'plan'=>$plan,
            'fact'=>$fact,
            'pct'=>$pct,
        ];
    }

    if ($export===1) {
        $table = [];
        $table[] = ['Операция','Сотрудник','Локация','Цех','План','Факт','% выполнения'];
        foreach ($out as $r) {
            $table[] = [$r['op_name'],$r['emp_name'],$r['location_name'],$r['workshop_name'],$r['plan'],$r['fact'],$r['pct']];
        }
        $fname = 'planfact_ops_'.date('Ymd_His').'.xlsx';
        xlsx_output($fname, $table, 'Операции');
    }

    render('planfact/operations', [
        'u'=>$u,
        'locations'=>$locations,
        'workshops'=>$workshops,
        'employees'=>$employees,
        'operations'=>$operations,
        'location_id'=>$location_id,
        'workshop_id'=>$workshop_id,
        'employee_id'=>$employee_id,
        'operation_id'=>$operation_id,
        'from'=>$from,
        'to'=>$to,
        'rows'=>$out,
        'days'=>$days,
    ]);
}
