<?php
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
require_once dirname(__DIR__, 2) . '/app/xlsx.php';

function finance_index() {
    finance_fot();
}

function finance_fot() {
    $u = require_role(['admin','director','prod_head']);

    $today = date('Y-m-d');
    $from = $_GET['from'] ?? date('Y-m-01');
    $to   = $_GET['to']   ?? $today;

    $location_id = (int)($_GET['location_id'] ?? 0);
    $workshop_id = (int)($_GET['workshop_id'] ?? 0);

    if (($u['role'] ?? '') === 'prod_head' && !empty($u['location_id'])) {
        $location_id = (int)$u['location_id'];
    }

    $export = (int)($_GET['export'] ?? 0);

    $locations = db_fetch_all(db_query("SELECT id,name FROM locations ORDER BY name"));
    $workshops = ($location_id>0)
        ? db_fetch_all(db_query("SELECT id,name,location_id FROM workshops WHERE location_id=$location_id ORDER BY name"))
        : db_fetch_all(db_query("SELECT id,name,location_id FROM workshops ORDER BY name"));

    $from_esc = db_escape($from);
    $to_esc   = db_escape($to);

    $where = "pl.work_date>='$from_esc' AND pl.work_date<='$to_esc'";
    if ($location_id>0) $where .= " AND pl.location_id=$location_id";
    if ($workshop_id>0) $where .= " AND pl.workshop_id=$workshop_id";

    $op_rows = db_fetch_all(db_query("
        SELECT
          e.id AS employee_id,
          e.full_name,
          e.location_id,
          e.workshop_id,
          e.brigadier_base_salary,
          e.brigadier_percent,
          l.name AS location_name,
          w.name AS workshop_name,
          SUM(pl.qty * IFNULL(NULLIF(pl.price_at_time,0), IFNULL(o.price,0))) AS ops_sum
        FROM production_logs pl
        JOIN employees e ON e.id=pl.employee_id
        JOIN locations l ON l.id=e.location_id
        JOIN workshops w ON w.id=e.workshop_id
        LEFT JOIN operations o ON o.id=pl.operation_id
        WHERE $where
        GROUP BY e.id
        ORDER BY l.name, w.name, e.full_name
    "));

    $awhere = "a.is_deleted=0 AND a.adj_date>='$from_esc' AND a.adj_date<='$to_esc'";
    if ($location_id>0) $awhere .= " AND e.location_id=$location_id";
    if ($workshop_id>0) $awhere .= " AND e.workshop_id=$workshop_id";

    $adj_rows = db_fetch_all(db_query("
        SELECT a.employee_id,
               SUM(CASE WHEN a.adj_type='bonus' THEN a.amount ELSE 0 END) AS bonus_sum,
               SUM(CASE WHEN a.adj_type='penalty' THEN a.amount ELSE 0 END) AS penalty_sum
        FROM employee_adjustments a
        JOIN employees e ON e.id=a.employee_id
        WHERE $awhere
        GROUP BY a.employee_id
    "));
    $adj_map = [];
    foreach ($adj_rows as $r) {
        $adj_map[(int)$r['employee_id']] = [
            'bonus'=>(float)$r['bonus_sum'],
            'penalty'=>(float)$r['penalty_sum'],
        ];
    }

    $ws_sum = db_fetch_all(db_query("
        SELECT e.workshop_id,
               SUM(pl.qty * IFNULL(NULLIF(pl.price_at_time,0), IFNULL(o.price,0))) AS ws_ops_sum
        FROM production_logs pl
        JOIN employees e ON e.id=pl.employee_id
        LEFT JOIN operations o ON o.id=pl.operation_id
        WHERE $where
        GROUP BY e.workshop_id
    "));
    $ws_map = [];
    foreach ($ws_sum as $r) $ws_map[(int)$r['workshop_id']] = (float)$r['ws_ops_sum'];

    $rows = [];
    $tot_ops = 0.0; $tot_bonus=0.0; $tot_penalty=0.0; $tot_brig=0.0; $tot_total=0.0;

    foreach ($op_rows as $r) {
        $eid = (int)$r['employee_id'];
        $ops = (float)($r['ops_sum'] ?? 0);
        $bonus = (float)($adj_map[$eid]['bonus'] ?? 0);
        $penalty = (float)($adj_map[$eid]['penalty'] ?? 0);

        $brig_base = (float)($r['brigadier_base_salary'] ?? 0);
        $brig_pct  = (float)($r['brigadier_percent'] ?? 0);

        $brig_part = 0.0;
        if ($brig_base>0 || $brig_pct>0) {
            $ws_total = (float)($ws_map[(int)$r['workshop_id']] ?? 0);
            $sub_sum = max(0, $ws_total - $ops);
            $brig_part = $brig_base + ($sub_sum * ($brig_pct/100.0));
        }

        $total = $ops + $bonus - $penalty + $brig_part;

        $tot_ops += $ops;
        $tot_bonus += $bonus;
        $tot_penalty += $penalty;
        $tot_brig += $brig_part;
        $tot_total += $total;

        $rows[] = [
            'location'=>$r['location_name'],
            'workshop'=>$r['workshop_name'],
            'employee'=>$r['full_name'],
            'ops_sum'=>round($ops,2),
            'bonus'=>round($bonus,2),
            'penalty'=>round($penalty,2),
            'brig'=>round($brig_part,2),
            'total'=>round($total,2),
        ];
    }

    $by_loc = [];
    foreach ($rows as $r) {
        $k = $r['location'];
        if (!isset($by_loc[$k])) $by_loc[$k] = ['ops'=>0,'bonus'=>0,'penalty'=>0,'brig'=>0,'total'=>0];
        $by_loc[$k]['ops'] += $r['ops_sum'];
        $by_loc[$k]['bonus'] += $r['bonus'];
        $by_loc[$k]['penalty'] += $r['penalty'];
        $by_loc[$k]['brig'] += $r['brig'];
        $by_loc[$k]['total'] += $r['total'];
    }

    if ($export===1) {
        $table = [];
        $table[] = ['Локация','Цех','Сотрудник','Операции (₽)','Премии (₽)','Штрафы (₽)','Бригадир (₽)','Итого (₽)'];
        foreach ($rows as $r) {
            $table[] = [$r['location'],$r['workshop'],$r['employee'],$r['ops_sum'],$r['bonus'],$r['penalty'],$r['brig'],$r['total']];
        }
        $table[] = ['','','ИТОГО',$tot_ops,$tot_bonus,$tot_penalty,$tot_brig,$tot_total];

        $fname = 'finance_fot_'.date('Ymd_His').'.xlsx';
        xlsx_output($fname, $table, 'ФОТ');
    }

    render('finance/fot', [
        'u'=>$u,
        'from'=>$from,
        'to'=>$to,
        'locations'=>$locations,
        'workshops'=>$workshops,
        'location_id'=>$location_id,
        'workshop_id'=>$workshop_id,
        'rows'=>$rows,
        'by_loc'=>$by_loc,
        'totals'=>[
            'ops'=>round($tot_ops,2),
            'bonus'=>round($tot_bonus,2),
            'penalty'=>round($tot_penalty,2),
            'brig'=>round($tot_brig,2),
            'total'=>round($tot_total,2),
        ],
    ]);
}

function finance_adjustments() {
    $u = require_role(['admin','director','prod_head']);

    $today = date('Y-m-d');
    $from = $_GET['from'] ?? date('Y-m-01');
    $to   = $_GET['to']   ?? $today;

    $location_id = (int)($_GET['location_id'] ?? 0);
    $workshop_id = (int)($_GET['workshop_id'] ?? 0);
    $employee_id = (int)($_GET['employee_id'] ?? 0);

    if (($u['role'] ?? '') === 'prod_head' && !empty($u['location_id'])) {
        $location_id = (int)$u['location_id'];
    }

    $locations = db_fetch_all(db_query("SELECT id,name FROM locations ORDER BY name"));
    $workshops = ($location_id>0)
        ? db_fetch_all(db_query("SELECT id,name,location_id FROM workshops WHERE location_id=$location_id ORDER BY name"))
        : db_fetch_all(db_query("SELECT id,name,location_id FROM workshops ORDER BY name"));

    $employees = ($workshop_id>0)
        ? db_fetch_all(db_query("SELECT id, full_name FROM employees WHERE is_active=1 AND workshop_id=$workshop_id ORDER BY full_name"))
        : db_fetch_all(db_query("SELECT id, full_name FROM employees WHERE is_active=1 ORDER BY full_name"));

    $msg = '';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $adj_date = trim($_POST['adj_date'] ?? $today);
        $employee_id = (int)($_POST['employee_id'] ?? 0);
        $adj_type = trim($_POST['adj_type'] ?? 'bonus');
        $amount = str_replace(',', '.', trim($_POST['amount'] ?? '0'));
        $reason = trim($_POST['reason'] ?? '');
        $comment = trim($_POST['comment'] ?? '');

        if ($employee_id<=0) $msg = 'Выберите сотрудника';
        else if (!is_numeric($amount) || (float)$amount<=0) $msg = 'Сумма должна быть больше 0';
        else if ($adj_type!=='bonus' && $adj_type!=='penalty') $msg = 'Неверный тип';
        else {
            $amount = (float)$amount;
            db_query("INSERT INTO employee_adjustments(adj_date,employee_id,adj_type,amount,reason,comment,created_at,created_by)
                      VALUES ('".db_escape($adj_date)."',$employee_id,'".db_escape($adj_type)."',$amount,'".db_escape($reason)."','".db_escape($comment)."',NOW(),".(int)$u['id'].")");
            header("Location: index.php?m=finance&a=adjustments&from=".urlencode($from)."&to=".urlencode($to)."&location_id=$location_id&workshop_id=$workshop_id&employee_id=$employee_id&ok=1");
            exit;
        }
    }

    $where = "a.is_deleted=0 AND a.adj_date>='".db_escape($from)."' AND a.adj_date<='".db_escape($to)."'";
    if ($employee_id>0) $where .= " AND a.employee_id=$employee_id";
    if ($location_id>0) $where .= " AND e.location_id=$location_id";
    if ($workshop_id>0) $where .= " AND e.workshop_id=$workshop_id";

    $rows = db_fetch_all(db_query("
        SELECT a.*, e.full_name, l.name AS location_name, w.name AS workshop_name, u.full_name AS user_name
        FROM employee_adjustments a
        JOIN employees e ON e.id=a.employee_id
        JOIN locations l ON l.id=e.location_id
        JOIN workshops w ON w.id=e.workshop_id
        LEFT JOIN users u ON u.id=a.created_by
        WHERE $where
        ORDER BY a.adj_date DESC, a.id DESC
        LIMIT 500
    "));

    render('finance/adjustments', [
        'u'=>$u,
        'from'=>$from,
        'to'=>$to,
        'locations'=>$locations,
        'workshops'=>$workshops,
        'employees'=>$employees,
        'location_id'=>$location_id,
        'workshop_id'=>$workshop_id,
        'employee_id'=>$employee_id,
        'rows'=>$rows,
        'msg'=>$msg,
        'ok'=>($_GET['ok'] ?? ''),
    ]);
}

function finance_adjustment_delete() {
    $u = require_role(['admin','director','prod_head']);
    if ($_SERVER['REQUEST_METHOD']!=='POST') { http_response_code(405); exit; }

    $id = (int)($_POST['id'] ?? 0);
    $reason = trim($_POST['reason'] ?? '');
    if ($id<=0) { header("Location: index.php?m=finance&a=adjustments"); exit; }
    if ($reason==='') { header("Location: index.php?m=finance&a=adjustments&err=reason"); exit; }

    db_query("UPDATE employee_adjustments SET is_deleted=1, comment=CONCAT(IFNULL(comment,''), '\n[Удалено]: ".db_escape($reason)."') WHERE id=$id");
    header("Location: index.php?m=finance&a=adjustments&ok=1");
    exit;
}
