<?php
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
require_once dirname(__DIR__, 2) . '/app/logger.php';
require_once dirname(__DIR__, 2) . '/app/audit.php';

function auth_login() {
    start_session();
    $err = isset($_GET['err']) ? $_GET['err'] : '';
    $msg = '';
    if ($err === 'blocked') $msg = 'Пользователь заблокирован. Обратитесь к администратору.';

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $login = trim($_POST['login'] ?? '');
        $pass  = (string)($_POST['password'] ?? '');

        $login_esc = db_escape($login);
        $res = db_query("SELECT * FROM users WHERE login='$login_esc' LIMIT 1");
        $u = db_fetch_one($res);

        if (!$u || !password_verify_simple($pass, $u['password_hash'])) {
            $msg = 'Неверный логин или пароль';
        } else if ((int)$u['is_active'] !== 1) {
            $msg = 'Пользователь заблокирован';
        } else {
            $_SESSION['user_id'] = (int)$u['id'];
            log_info('LOGIN', ['user_id'=>(int)$u['id'], 'login'=>$u['login']]);
            audit('LOGIN','users',(int)$u['id'],(int)$u['id'], null);
            header('Location: index.php');
            exit;
        }
    }

    require dirname(__DIR__, 2) . '/views/auth/login.php';
}

function auth_logout() {
    $u = auth_user();
    if ($u) { log_info('LOGOUT', ['user_id'=>(int)$u['id']]); audit('LOGOUT','users',(int)$u['id'],(int)$u['id'], null); }

    session_unset();
    session_destroy();
    header('Location: index.php?m=auth&a=login');
    exit;
}
