<?php
// index.php — простой роутер "Аэросмит"
require_once __DIR__ . '/app/config.php';
require_once __DIR__ . '/app/db.php';
require_once __DIR__ . '/app/auth.php';
if (file_exists(__DIR__ . '/modules/production/controller_additions.php')) { require_once __DIR__ . '/modules/production/controller_additions.php'; }
require_once __DIR__ . '/app/view.php';

$m = $_GET['m'] ?? 'dashboard';
$a = $_GET['a'] ?? 'index';



$allowed = [
  'dashboard','auth','settings','materials','warehouse','production','staff',
  'parts','planfact','quality','finance'
];
if (!in_array($m, $allowed, true)) $m = 'dashboard';

$controller = __DIR__ . '/modules/' . $m . '/controller.php';
if (!file_exists($controller)) {
  http_response_code(404);
  echo "Модуль не найден";
  exit;
}
require_once $controller;

// доп. функции для settings (операции)
if ($m === 'settings' && file_exists(__DIR__ . '/modules/settings/controller_additions.php')) {
  require_once __DIR__ . '/modules/settings/controller_additions.php';
}

$fn = $m . '_' . $a;
if (!function_exists($fn)) {
  // fallback: если у модуля есть index()
  $fn = $m . '_index';
}
if (!function_exists($fn)) {
  http_response_code(404);
  echo "Действие не найдено";
  exit;
}

$fn();
