-- db/update_018_tg_notify_prefs.sql
SET NAMES utf8mb4;

CREATE TABLE IF NOT EXISTS tg_notify_role (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  notif_key VARCHAR(32) NOT NULL,
  role VARCHAR(32) NOT NULL,
  is_enabled TINYINT(1) NOT NULL DEFAULT 1,
  send_time TIME NULL,
  PRIMARY KEY (id),
  UNIQUE KEY uq_role_notif (notif_key, role)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS tg_notify_user (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  notif_key VARCHAR(32) NOT NULL,
  user_id INT UNSIGNED NOT NULL,
  is_enabled TINYINT(1) NOT NULL DEFAULT 1,
  send_time TIME NULL,
  PRIMARY KEY (id),
  UNIQUE KEY uq_user_notif (notif_key, user_id),
  CONSTRAINT fk_tg_notify_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS tg_notify_state (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  notif_key VARCHAR(32) NOT NULL,
  user_id INT UNSIGNED NOT NULL,
  last_sent_date DATE NULL,
  PRIMARY KEY (id),
  UNIQUE KEY uq_state (notif_key, user_id),
  CONSTRAINT fk_tg_state_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT IGNORE INTO tg_notify_role(notif_key, role, is_enabled, send_time) VALUES
('low_material','admin',1,NULL),
('low_material','director',1,NULL),
('low_material','prod_head',1,NULL),
('low_material','brigadier',0,NULL),
('low_material','storekeeper',1,NULL),
('low_material','otk',0,NULL),

('daily_products','admin',1,'20:00:00'),
('daily_products','director',1,'20:00:00'),
('daily_products','prod_head',0,'20:00:00'),
('daily_products','brigadier',0,'20:00:00'),
('daily_products','storekeeper',0,'20:00:00'),
('daily_products','otk',0,'20:00:00');
