-- db/update_011_quality_otk.sql
-- Модуль ОТК (Качество): учет годных/брака по деталям
SET NAMES utf8mb4;

CREATE TABLE IF NOT EXISTS qc_parts (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  qc_date DATE NOT NULL,
  location_id INT UNSIGNED NOT NULL,
  workshop_id INT UNSIGNED NOT NULL,
  part_id INT UNSIGNED NOT NULL,
  good_qty DECIMAL(14,3) NOT NULL DEFAULT 0,
  bad_qty DECIMAL(14,3) NOT NULL DEFAULT 0,
  comment TEXT,
  created_at DATETIME NOT NULL,
  created_by INT UNSIGNED NOT NULL,
  updated_at DATETIME DEFAULT NULL,
  updated_by INT UNSIGNED DEFAULT NULL,
  is_deleted TINYINT(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (id),
  KEY idx_qc_date (qc_date),
  KEY idx_qc_loc (location_id),
  KEY idx_qc_ws (workshop_id),
  KEY idx_qc_part (part_id),
  CONSTRAINT fk_qc_loc FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE RESTRICT,
  CONSTRAINT fk_qc_ws FOREIGN KEY (workshop_id) REFERENCES workshops(id) ON DELETE RESTRICT,
  CONSTRAINT fk_qc_part FOREIGN KEY (part_id) REFERENCES parts(id) ON DELETE RESTRICT,
  CONSTRAINT fk_qc_user_c FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT,
  CONSTRAINT fk_qc_user_u FOREIGN KEY (updated_by) REFERENCES users(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
