-- db/update_009_assembly.sql
-- Комплектация изделия (цех упаковки): учет деталей у места (цех/сотрудник) + сборка изделий
SET NAMES utf8mb4;

CREATE TABLE IF NOT EXISTS part_place_moves (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  location_id INT UNSIGNED NOT NULL,
  place_type ENUM('workshop','employee') NOT NULL,
  place_id INT UNSIGNED NOT NULL,
  part_id INT UNSIGNED NOT NULL,
  move_type ENUM('in','out','adjust','reverse') NOT NULL,
  qty DECIMAL(14,3) NOT NULL DEFAULT 0,
  reason VARCHAR(255) NOT NULL DEFAULT '',
  comment TEXT,
  created_at DATETIME NOT NULL,
  created_by INT UNSIGNED NOT NULL,
  PRIMARY KEY (id),
  KEY idx_ppm_loc (location_id),
  KEY idx_ppm_place (place_type, place_id),
  KEY idx_ppm_part (part_id),
  KEY idx_ppm_dt (created_at),
  CONSTRAINT fk_ppm_loc FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE CASCADE,
  CONSTRAINT fk_ppm_part FOREIGN KEY (part_id) REFERENCES parts(id) ON DELETE RESTRICT,
  CONSTRAINT fk_ppm_user FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS product_assemblies (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  location_id INT UNSIGNED NOT NULL,
  workshop_id INT UNSIGNED NOT NULL, -- цех упаковки
  product_id INT UNSIGNED NOT NULL,
  qty DECIMAL(14,3) NOT NULL DEFAULT 0,
  comment TEXT,
  created_at DATETIME NOT NULL,
  created_by INT UNSIGNED NOT NULL,
  product_move_id BIGINT UNSIGNED DEFAULT NULL,
  PRIMARY KEY (id),
  KEY idx_pa_loc (location_id),
  KEY idx_pa_ws (workshop_id),
  KEY idx_pa_prod (product_id),
  KEY idx_pa_dt (created_at),
  CONSTRAINT fk_pa_loc FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE CASCADE,
  CONSTRAINT fk_pa_ws FOREIGN KEY (workshop_id) REFERENCES workshops(id) ON DELETE RESTRICT,
  CONSTRAINT fk_pa_prod FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE RESTRICT,
  CONSTRAINT fk_pa_user FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS product_assembly_parts (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  assembly_id BIGINT UNSIGNED NOT NULL,
  part_id INT UNSIGNED NOT NULL,
  qty DECIMAL(14,3) NOT NULL DEFAULT 0,
  source_place_type ENUM('workshop','employee') NOT NULL,
  source_place_id INT UNSIGNED NOT NULL,
  ppm_out_id BIGINT UNSIGNED DEFAULT NULL,
  PRIMARY KEY (id),
  KEY idx_pap_asm (assembly_id),
  KEY idx_pap_part (part_id),
  CONSTRAINT fk_pap_asm FOREIGN KEY (assembly_id) REFERENCES product_assemblies(id) ON DELETE CASCADE,
  CONSTRAINT fk_pap_part FOREIGN KEY (part_id) REFERENCES parts(id) ON DELETE RESTRICT,
  CONSTRAINT fk_pap_ppm FOREIGN KEY (ppm_out_id) REFERENCES part_place_moves(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
