-- db/update_008_finished_parts.sql
-- Производство: готовые детали + склад готовых деталей (виртуальная сущность)
SET NAMES utf8mb4;

CREATE TABLE IF NOT EXISTS finished_part_moves (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  location_id INT UNSIGNED NOT NULL,
  from_workshop_id INT UNSIGNED NOT NULL,
  part_id INT UNSIGNED NOT NULL,
  move_type ENUM('in','issue','adjust','reverse') NOT NULL,
  qty DECIMAL(14,3) NOT NULL DEFAULT 0, -- всегда положительное
  to_place_type ENUM('workshop','employee') DEFAULT NULL,
  to_place_id INT UNSIGNED DEFAULT NULL,
  reason VARCHAR(255) NOT NULL DEFAULT '',
  comment TEXT,
  is_reversed TINYINT(1) NOT NULL DEFAULT 0,
  reversed_of BIGINT UNSIGNED DEFAULT NULL,
  created_at DATETIME NOT NULL,
  created_by INT UNSIGNED NOT NULL,
  PRIMARY KEY (id),
  KEY idx_fpm_loc (location_id),
  KEY idx_fpm_ws (from_workshop_id),
  KEY idx_fpm_part (part_id),
  KEY idx_fpm_dt (created_at),
  KEY idx_fpm_rev (reversed_of),
  CONSTRAINT fk_fpm_loc FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE CASCADE,
  CONSTRAINT fk_fpm_ws FOREIGN KEY (from_workshop_id) REFERENCES workshops(id) ON DELETE RESTRICT,
  CONSTRAINT fk_fpm_part FOREIGN KEY (part_id) REFERENCES parts(id) ON DELETE RESTRICT,
  CONSTRAINT fk_fpm_user FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
