<?php
// app/telegram.php — отправка сообщений в Telegram
require_once __DIR__ . '/db.php';

function app_setting_get($key, $default='') {
    $key_esc = db_escape($key);
    $r = db_fetch_one(db_query("SELECT value FROM app_settings WHERE `key`='$key_esc' LIMIT 1"));
    if (!$r) return $default;
    return (string)$r['value'];
}

function app_setting_set($key, $value) {
    $key_esc = db_escape($key);
    $val_esc = db_escape((string)$value);
    db_query("INSERT INTO app_settings(`key`,`value`) VALUES ('$key_esc','$val_esc')
              ON DUPLICATE KEY UPDATE `value`='$val_esc'");
}

function tg_send_message($chat_id, $text) {
    $token = trim(app_setting_get('telegram_bot_token',''));
    if ($token==='') return false;
    $chat_id = trim((string)$chat_id);
    if ($chat_id==='') return false;

    $url = "https://api.telegram.org/bot".$token."/sendMessage";
    $post = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => 1,
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $resp = curl_exec($ch);
    $http = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    return ($http >= 200 && $http < 300);
}

function tg_roles_enabled($code) {
    $code_esc = db_escape($code);
    return db_fetch_all(db_query("SELECT role, is_enabled, send_time FROM telegram_notification_roles WHERE notification_code='$code_esc'"));
}

function tg_users_for_role($role, $location_id = 0) {
    $role_esc = db_escape($role);
    $location_id = (int)$location_id;

    // users.telegram_id хранится в users (по вашим правилам)
    $sql = "SELECT id, full_name, telegram_id, role FROM users WHERE role='$role_esc' AND is_active=1 AND telegram_id<>''";
    if ($location_id>0 && !in_array($role, ['admin','director'], true)) {
        // не админ/директор — ограничиваем по доступным локациям пользователя
        $sql .= " AND EXISTS(SELECT 1 FROM user_locations ul WHERE ul.user_id=users.id AND ul.location_id=$location_id)";
    }
    return db_fetch_all(db_query($sql));
}
