<?php
// app/finished_parts.php — виртуальный "Склад готовых деталей"
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/audit.php';
require_once __DIR__ . '/part_place.php';

function fp_get_balance($location_id, $from_workshop_id, $part_id) {
    $location_id = (int)$location_id;
    $from_workshop_id = (int)$from_workshop_id;
    $part_id = (int)$part_id;

    $row = db_fetch_one(db_query("
      SELECT COALESCE(SUM(delta),0) AS bal FROM (
        SELECT qty AS delta
        FROM finished_part_moves
        WHERE location_id=$location_id AND from_workshop_id=$from_workshop_id AND part_id=$part_id
          AND is_reversed=0 AND move_type IN ('in','adjust','reverse')
        UNION ALL
        SELECT -qty AS delta
        FROM finished_part_moves
        WHERE location_id=$location_id AND from_workshop_id=$from_workshop_id AND part_id=$part_id
          AND is_reversed=0 AND move_type='issue'
      ) t
    "));
    return $row ? (float)$row['bal'] : 0.0;
}

function fp_list_balances_by_workshop($location_id, $from_workshop_id) {
    $location_id = (int)$location_id;
    $from_workshop_id = (int)$from_workshop_id;

    return db_fetch_all(db_query("
      SELECT prt.id, prt.name,
        COALESCE((
          SELECT SUM(delta) FROM (
            SELECT qty AS delta
            FROM finished_part_moves m
            WHERE m.location_id=$location_id AND m.from_workshop_id=$from_workshop_id AND m.part_id=prt.id AND m.is_reversed=0 AND m.move_type IN ('in','adjust','reverse')
            UNION ALL
            SELECT -qty AS delta
            FROM finished_part_moves m
            WHERE m.location_id=$location_id AND m.from_workshop_id=$from_workshop_id AND m.part_id=prt.id AND m.is_reversed=0 AND m.move_type='issue'
          ) x
        ),0) AS bal
      FROM parts prt
      WHERE prt.is_active=1
      ORDER BY prt.name
    "));
}

function fp_add_in($location_id, $from_workshop_id, $part_id, $qty, $comment, $user_id) {
    $location_id = (int)$location_id;
    $from_workshop_id = (int)$from_workshop_id;
    $part_id = (int)$part_id;
    $qty = (float)$qty;
    $user_id = (int)$user_id;
    $comment_esc = db_escape($comment);

    db_query("INSERT INTO finished_part_moves(location_id,from_workshop_id,part_id,move_type,qty,reason,comment,created_at,created_by)
              VALUES ($location_id,$from_workshop_id,$part_id,'in',$qty,'Готовые детали','$comment_esc',NOW(),$user_id)");
    $id = (int)db_last_id();
    audit('CREATE','finished_part_moves',$id,$user_id, ['type'=>'in','part_id'=>$part_id,'qty'=>$qty,'from_workshop_id'=>$from_workshop_id]);
    return $id;
}

function fp_issue($location_id, $from_workshop_id, $part_id, $qty, $to_type, $to_id, $comment, $user_id) {
    $location_id = (int)$location_id;
    $from_workshop_id = (int)$from_workshop_id;
    $part_id = (int)$part_id;
    $qty = (float)$qty;
    $to_id = (int)$to_id;
    $user_id = (int)$user_id;
    $to_type = ($to_type==='employee') ? 'employee' : 'workshop';
    $comment_esc = db_escape($comment);

    db_query("INSERT INTO finished_part_moves(location_id,from_workshop_id,part_id,move_type,qty,to_place_type,to_place_id,reason,comment,created_at,created_by)
              VALUES ($location_id,$from_workshop_id,$part_id,'issue',$qty,'$to_type',$to_id,'Выдача деталей','$comment_esc',NOW(),$user_id)");
    $id = (int)db_last_id();
    audit('CREATE','finished_part_moves',$id,$user_id, ['type'=>'issue','part_id'=>$part_id,'qty'=>$qty,'to'=>$to_type,'to_id'=>$to_id,'from_workshop_id'=>$from_workshop_id]);
    return $id;
}
