<?php
// app/db.php
function db() {
    static $conn = null;
    if ($conn !== null) return $conn;

    $cfg = require __DIR__ . '/config.php';
    $db = $cfg['db'];

    $conn = mysqli_connect($db['host'], $db['user'], $db['pass'], $db['name']);
    if (!$conn) {
        http_response_code(500);
        die('Ошибка подключения к БД');
    }
    mysqli_set_charset($conn, $db['charset']);
    return $conn;
}

function db_escape($s) {
    return mysqli_real_escape_string(db(), $s);
}

function db_query($sql) {
    $res = mysqli_query(db(), $sql);
    if ($res === false) {
        // Ошибка БД скрыта от пользователя, пишем в лог
        require_once __DIR__ . '/logger.php';
        log_error('DB_ERROR', ['sql' => $sql, 'error' => mysqli_error(db())]);
        return $res;
    }

    // Автологирование INSERT/UPDATE/DELETE/REPLACE
    // Важно: не логируем собственные записи аудита и не уходим в рекурсию.
    $internal = !empty($GLOBALS['AUDIT_INTERNAL']);
    if (!$internal) {
        $q = ltrim($sql);
        if (preg_match('/^(INSERT\s+INTO|REPLACE\s+INTO)\s+`?([a-zA-Z0-9_]+)`?/i', $q, $m)) {
            $tbl = $m[2];
            if ($tbl !== 'audit_logs' && $tbl !== 'audit_log') {
                $uid = 0;
                if (session_status() === PHP_SESSION_ACTIVE && !empty($_SESSION['user_id'])) $uid = (int)$_SESSION['user_id'];
                require_once __DIR__ . '/audit.php';
                $id = mysqli_insert_id(db());
                audit('CREATE', $tbl, $id ?: 0, $uid, ['sql'=>mb_substr($q,0,500)]);
            }
        } elseif (preg_match('/^UPDATE\s+`?([a-zA-Z0-9_]+)`?/i', $q, $m)) {
            $tbl = $m[1];
            if ($tbl !== 'audit_logs' && $tbl !== 'audit_log') {
                $uid = 0;
                if (session_status() === PHP_SESSION_ACTIVE && !empty($_SESSION['user_id'])) $uid = (int)$_SESSION['user_id'];
                require_once __DIR__ . '/audit.php';
                audit('UPDATE', $tbl, 0, $uid, ['sql'=>mb_substr($q,0,500)]);
            }
        } elseif (preg_match('/^DELETE\s+FROM\s+`?([a-zA-Z0-9_]+)`?/i', $q, $m)) {
            $tbl = $m[1];
            if ($tbl !== 'audit_logs' && $tbl !== 'audit_log') {
                $uid = 0;
                if (session_status() === PHP_SESSION_ACTIVE && !empty($_SESSION['user_id'])) $uid = (int)$_SESSION['user_id'];
                require_once __DIR__ . '/audit.php';
                audit('DELETE', $tbl, 0, $uid, ['sql'=>mb_substr($q,0,500)]);
            }
        }
    }

    return $res;
}

function db_fetch_all($res) {
    $rows = [];
    if (!$res) return $rows;
    while ($row = mysqli_fetch_assoc($res)) $rows[] = $row;
    return $rows;
}

function db_fetch_one($res) {
    if (!$res) return null;
    return mysqli_fetch_assoc($res) ?: null;
}

function db_last_id() {
    return mysqli_insert_id(db());
}
