<?php
// app/auth.php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/logger.php';

function start_session() {
    $cfg = require __DIR__ . '/config.php';
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    // Таймаут
    $now = time();
    $timeout = (int)$cfg['session_timeout_seconds'];
    if (!empty($_SESSION['last_activity']) && ($now - (int)$_SESSION['last_activity'] > $timeout)) {
        session_unset();
        session_destroy();
        session_start();
    }
    $_SESSION['last_activity'] = $now;
}

function password_hash_simple($plain) {
    // Для MVP используем password_hash(). PDO нет — это не связано.
    return password_hash($plain, PASSWORD_BCRYPT);
}

function password_verify_simple($plain, $hash) {
    return password_verify($plain, $hash);
}

function auth_user() {
    start_session();
    if (!empty($_SESSION['user_id'])) {
        return get_user_by_id((int)$_SESSION['user_id']);
    }
    return null;
}

function require_login() {
    $u = auth_user();
    if (!$u) {
        header('Location: index.php?m=auth&a=login');
        exit;
    }
    if ((int)$u['is_active'] !== 1) {
        session_unset();
        session_destroy();
        header('Location: index.php?m=auth&a=login&err=blocked');
        exit;
    }
    return $u;
}

function get_user_by_id($id) {
    $id = (int)$id;
    $res = db_query("SELECT * FROM users WHERE id=$id LIMIT 1");
    return db_fetch_one($res);
}

function get_user_locations($user_id) {
    $user_id = (int)$user_id;
    $res = db_query("SELECT ul.location_id, l.name AS location_name
                     FROM user_locations ul
                     JOIN locations l ON l.id = ul.location_id
                     WHERE ul.user_id=$user_id
                     ORDER BY l.name");
    return db_fetch_all($res);
}

function user_has_role($user, $roles) {
    if (!$user) return false;
    if (is_string($roles)) $roles = [$roles];
    return in_array($user['role'], $roles, true);
}

// Проверка доступа к модулю: по роли
function require_role($roles) {
    $u = require_login();
    if (!user_has_role($u, $roles)) {
        http_response_code(403);
        echo "Доступ запрещён";
        exit;
    }
    return $u;
}

// Проверка доступа к локации по пользователю
function require_location_access($user_id, $location_id) {
    $user_id = (int)$user_id;
    $location_id = (int)$location_id;
    $res = db_query("SELECT 1 FROM user_locations WHERE user_id=$user_id AND location_id=$location_id LIMIT 1");
    $row = db_fetch_one($res);
    if (!$row) {
        http_response_code(403);
        echo "Нет доступа к локации";
        exit;
    }
}
