<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <a class="crumb" href="index.php?m=warehouse&a=index&type=<?= h($type) ?>">Склад</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Списание</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2"><?= h($title) ?></h2>
    <div class="muted">причина + комментарий обязательны</div>
  </div>

  <?php if (!empty($msg)): ?><div class="alert"><?= h($msg) ?></div><?php endif; ?>

  <form method="post">
    <div class="form-grid">
      <div class="field">
        <label>Локация*</label>
        <select name="location_id" required onchange="this.form.submit()">
          <option value="0">— выберите —</option>
          <?php foreach ($locations as $l): ?>
            <option value="<?= (int)$l['location_id'] ?>" <?= ((int)$location_id===(int)$l['location_id']?'selected':'') ?>>
              <?= h($l['location_name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="field">
        <label>Позиция*</label>
        <select name="item_id" required>
          <option value="0">— выберите —</option>
          <?php foreach ($items as $it): ?>
            <option value="<?= (int)$it['id'] ?>"><?= h($it['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>

    <div class="form-grid" style="margin-top:12px;">
      <div class="field">
        <label>Откуда списать*</label>
        <select name="from_place_id" required>
          <option value="0">— выберите —</option>
          <?php foreach ($places as $p): ?>
            <option value="<?= (int)$p['id'] ?>"><?= h($p['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="field">
        <label>Количество*</label>
        <input name="qty" required placeholder="например: 1">
      </div>
    </div>

    <div class="form-grid" style="margin-top:12px;">
      <div class="field">
        <label>Причина*</label>
        <input name="reason" required placeholder="например: поломка/износ">
      </div>
      <div class="field">
        <label>Комментарий*</label>
        <input name="comment" required placeholder="детали списания">
      </div>
    </div>

    <div class="actions">
      <button class="btn danger" type="submit">Списать</button>
      <a class="btn" href="index.php?m=warehouse&a=index&type=<?= h($type) ?>">Назад</a>
    </div>
  </form>
</section>
