<?php require __DIR__ . '/_tabs.php'; ?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Склад</span>
  <span class="crumb-sep">/</span>
  <span class="crumb">Готовая продукция</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">Склад → Готовая продукция</h2>
    <div class="muted">остатки по локациям + отгрузка + история</div>
  </div>

  <form method="get" class="tabs" style="align-items:center;">
    <input type="hidden" name="m" value="warehouse">
    <input type="hidden" name="a" value="index">
    <input type="hidden" name="type" value="product">

    <select name="location_id" onchange="this.form.submit()">
      <option value="0">Локация: выберите</option>
      <?php foreach ($locations as $l): ?>
        <option value="<?= (int)$l['location_id'] ?>" <?= ((int)$location_id===(int)$l['location_id']?'selected':'') ?>>
          <?= h($l['location_name']) ?>
        </option>
      <?php endforeach; ?>
    </select>

    <?php if ($location_id>0): ?>
      <span class="pill">Показано по локации</span>
    <?php else: ?>
      <span class="pill">Выберите локацию</span>
    <?php endif; ?>
  </form>

  <?php if ($location_id<=0): ?>
    <div class="alert">Выберите локацию, чтобы увидеть остатки готовой продукции.</div>
  <?php else: ?>
    <div class="table-wrap">
      <table>
        <thead>
          <tr>
            <th>Изделие</th>
            <th>Остаток</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $r): ?>
          <tr>
            <td><b><?= h($r['name']) ?></b></td>
            <td><?= h($r['bal']) ?></td>
            <td style="white-space:nowrap;">
              <a class="btn primary" href="index.php?m=warehouse&a=product_view&type=product&id=<?= (int)$r['id'] ?>&location_id=<?= (int)$location_id ?>">
                Отгрузить / История
              </a>
            </td>
          </tr>
          <?php endforeach; ?>
          <?php if (count($rows)===0): ?>
            <tr><td colspan="3" class="muted">Нет изделий (создай в Настройках → Готовая продукция)</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <div class="small" style="margin-top:10px;">
      Остаток считается по журналу движений готовой продукции (поступления/отгрузки/корректировки/отмены).
    </div>
  <?php endif; ?>
</section>
