<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Персонал</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">Персонал</h2>
    <div class="muted">минимальный справочник (нужен для выработки)</div>
  </div>

  <form method="get" class="tabs" style="align-items:center;">
    <input type="hidden" name="m" value="staff">
    <input type="hidden" name="a" value="index">

    <select name="location_id" onchange="this.form.submit()">
      <option value="0">Локация: все</option>
      <?php foreach ($locations as $l): ?>
        <option value="<?= (int)$l['location_id'] ?>" <?= ((int)$location_id===(int)$l['location_id']?'selected':'') ?>>
          <?= h($l['location_name']) ?>
        </option>
      <?php endforeach; ?>
    </select>

    <select name="workshop_id">
      <option value="0">Цех: все</option>
      <?php foreach ($workshops as $w): ?>
        <option value="<?= (int)$w['id'] ?>" <?= ((int)$workshop_id===(int)$w['id']?'selected':'') ?>>
          <?= h($w['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>

    <input name="q" placeholder="поиск: ФИО или номер" value="<?= h($q) ?>">
    <button class="btn" type="submit">Показать</button>

    <a class="btn primary" href="index.php?m=staff&a=edit">+ Создать</a>
  </form>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>№</th>
          <th>ФИО</th>
          <th>Локация</th>
          <th>Цех</th>
          <th>Телефон</th>
          <th>Статус</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
        <tr>
          <td class="muted"><?= h($r['emp_no']) ?></td>
          <td><b><?= h($r['full_name']) ?></b></td>
          <td class="muted"><?= h($r['location_name']) ?></td>
          <td class="muted"><?= h($r['workshop_name']) ?></td>
          <td class="muted"><?= h($r['phone']) ?></td>
          <td><?= ((int)$r['is_active']===1) ? '<span class="pill" style="color:var(--ok);">активен</span>' : '<span class="pill" style="color:var(--danger);">выкл</span>' ?></td>
          <td style="white-space:nowrap;">
            <a class="btn" href="index.php?m=staff&a=edit&id=<?= (int)$r['id'] ?>">Редактировать</a>
            <?php if (in_array($u['role'], ['admin','director'], true)): ?>
              <a class="btn danger" href="index.php?m=staff&a=delete&id=<?= (int)$r['id'] ?>" onclick="return confirm('Удалить работника?')">Удалить</a>
            <?php endif; ?>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (count($rows)===0): ?>
        <tr><td colspan="7" class="muted">Нет данных</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</section>
