<?php $tab='users'; require __DIR__ . '/_tabs.php'; ?>
<div class="card">
  <div class="card-head">
    <h2 class="h2">Настройки → Пользователи</h2>
    <div class="muted">управление доступами</div>
  </div>

  <form class="tabs" method="get" style="margin-bottom:10px;">
    <input type="hidden" name="m" value="settings">
    <input type="hidden" name="a" value="users">

    <select name="role">
      <option value="">Все роли</option>
      <?php foreach ($roles as $k=>$v): ?>
        <option value="<?= h($k) ?>" <?= ($filter_role===$k?'selected':'') ?>><?= h($v) ?></option>
      <?php endforeach; ?>
    </select>

    <select name="location_id">
      <option value="0">Все локации</option>
      <?php foreach ($locations as $l): ?>
        <option value="<?= (int)$l['id'] ?>" <?= ((int)$filter_location_id===(int)$l['id']?'selected':'') ?>><?= h($l['name']) ?></option>
      <?php endforeach; ?>
    </select>

    <button class="btn" type="submit">Фильтр</button>
    <a class="btn primary" href="index.php?m=settings&a=user_edit">+ Создать</a>
  </form>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>ФИО</th>
          <th>Логин</th>
          <th>Должность</th>
          <th>Роль</th>
          <th>Telegram ID</th>
          <th>Статус</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($users as $it): ?>
        <tr>
          <td><?= h($it['full_name']) ?></td>
          <td><?= h($it['login']) ?></td>
          <td><?= h($it['position']) ?></td>
          <td><?= h($roles[$it['role']] ?? $it['role']) ?></td>
          <td><?= h($it['telegram_id']) ?></td>
          <td>
            <?php if ((int)$it['is_active']===1): ?>
              <span class="pill" style="color:var(--ok);">активен</span>
            <?php else: ?>
              <span class="pill" style="color:var(--danger);">заблокирован</span>
            <?php endif; ?>
          </td>
          <td style="white-space:nowrap;">
            <a class="btn" href="index.php?m=settings&a=user_edit&id=<?= (int)$it['id'] ?>">Редактировать</a>
            <a class="btn danger" href="index.php?m=settings&a=user_delete&id=<?= (int)$it['id'] ?>" onclick="return confirm('Удалить пользователя?')">Удалить</a>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (count($users)===0): ?>
        <tr><td colspan="7" class="muted">Нет данных</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<div class="card" style="margin-top:14px;">
  <div class="card-head">
    <h2 class="h2">Подсказка</h2>
    <div class="muted">MVP</div>
  </div>
  <div class="muted">Если вы создаёте пользователя без пароля — по умолчанию ставится <b>admin123</b>.</div>
</div>
