<?php $tab='products'; require __DIR__ . '/_tabs.php'; ?>
<script src="assets/products.js?v=1" defer></script>

<div class="card">
  <div class="card-head">
    <h2 class="h2">Изделие</h2>
    <div class="muted"><?= $id>0 ? 'редактирование' : 'создание' ?></div>
  </div>

  <?php if (!empty($msg)): ?><div class="alert"><?= h($msg) ?></div><?php endif; ?>

  <form method="post">
    <div class="form-grid">
      <div class="field">
        <label>Наименование изделия*</label>
        <input name="name" required value="<?= h($item['name'] ?? '') ?>">
      </div>
      <div class="field">
        <label><input type="checkbox" name="is_active" value="1" <?= ((int)($item['is_active'] ?? 1)===1?'checked':'') ?>> Активно</label>
      </div>
    </div>

    <div class="field" style="margin-top:12px;">
      <label>Описание</label>
      <textarea name="description"><?= h($item['description'] ?? '') ?></textarea>
    </div>

    <div class="hr"></div>

    <section class="card soft">
      <div class="card-head">
        <h2 class="h2">Состав изделия</h2>
        <div class="muted">детали и количество каждой детали на 1 изделие</div>
      </div>

      <div class="actions">
        <button class="btn" type="button" onclick="prodAddRow()">+ Добавить деталь</button>
      </div>

      <div class="table-wrap">
        <table>
          <thead>
            <tr>
              <th>Деталь</th>
              <th>Кол-во на 1 изделие</th>
              <th></th>
            </tr>
          </thead>
          <tbody id="pp-body">
            <?php foreach ($pp as $r): ?>
            <tr>
              <td>
                <select name="pp_part_id[]">
                  <?php foreach ($parts as $p): ?>
                    <option value="<?= (int)$p['id'] ?>" <?= ((int)$r['part_id']===(int)$p['id']?'selected':'') ?>><?= h($p['name']) ?></option>
                  <?php endforeach; ?>
                </select>
              </td>
              <td><input name="pp_qty[]" value="<?= h($r['qty_per_product']) ?>" style="max-width:220px;"></td>
              <td><button class="btn danger" type="button" onclick="prodDelRow(this)">Удалить</button></td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <template id="pp-template">
        <tr>
          <td>
            <select name="pp_part_id[]">
              <?php foreach ($parts as $p): ?>
                <option value="<?= (int)$p['id'] ?>"><?= h($p['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </td>
          <td><input name="pp_qty[]" value="1" style="max-width:220px;"></td>
          <td><button class="btn danger" type="button" onclick="prodDelRow(this)">Удалить</button></td>
        </tr>
      </template>

      <div class="small" style="margin-top:10px;">
        Одна и та же деталь может входить в несколько изделий — это поддерживается.
      </div>
    </section>

    <div class="actions" style="margin-top:14px;">
      <button class="btn primary" type="submit">Сохранить</button>
      <a class="btn" href="index.php?m=settings&a=products">Назад</a>
    </div>
  </form>
</div>
