<?php require __DIR__ . '/_tabs.php'; ?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Настройки</span>
  <span class="crumb-sep">/</span>
  <span class="crumb">Логи</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">Логирование действий</h2>
    <div class="muted">кто / что / когда. По умолчанию скрыты технические SQL-события.</div>
  </div>

  <form method="get" class="tabs" style="align-items:end;">
    <input type="hidden" name="m" value="settings">
    <input type="hidden" name="a" value="logs">

    <div class="field">
      <label>Период: с</label>
      <input type="date" name="from" value="<?= h($from) ?>">
    </div>
    <div class="field">
      <label>по</label>
      <input type="date" name="to" value="<?= h($to) ?>">
    </div>

    <div class="field">
      <label>Пользователь</label>
      <select name="user_id">
        <option value="0">Все</option>
        <?php foreach ($users as $us): ?>
          <option value="<?= (int)$us['id'] ?>" <?= ((int)$user_id===(int)$us['id']?'selected':'') ?>>
            <?= h($us['full_name']) ?> (<?= h($us['role']) ?>)
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>Модуль</label>
      <select name="module">
        <option value="">Все</option>
        <?php foreach ($mods as $m0): $val = (string)($m0['module'] ?? ''); ?>
          <option value="<?= h($val) ?>" <?= ($module===$val?'selected':'') ?>><?= h($val) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>Действие</label>
      <select name="action">
        <option value="">Все</option>
        <?php foreach ($acts as $a0): $val = (string)($a0['action'] ?? ''); ?>
          <option value="<?= h($val) ?>" <?= ($action===$val?'selected':'') ?>><?= h($val) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>Таблица</label>
      <select name="table">
        <option value="">Все</option>
        <?php foreach ($tabs as $t0): $val = (string)($t0['table_name'] ?? ''); ?>
          <option value="<?= h($val) ?>" <?= ($table===$val?'selected':'') ?>><?= h($val) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>&nbsp;</label>
      <label style="display:flex; gap:8px; align-items:center; user-select:none;">
        <input type="checkbox" name="show_sql" value="1" <?= (!empty($show_sql)?'checked':'') ?>>
        <span class="muted">Показывать SQL</span>
      </label>
    </div>

    <div class="actions">
      <button class="btn" type="submit">Показать</button>
    </div>
  </form>

  <div class="hr"></div>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Дата</th>
          <th>Пользователь</th>
          <th>Событие</th>
          <th>Модуль</th>
          <th>Действие</th>
          <th>Таблица</th>
          <th>ID</th>
          <th>IP</th>
          <th>Детали</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td class="muted"><?= h($r['created_at']) ?></td>
            <td><b><?= h($r['user_name'] ?? '') ?></b> <span class="muted">(<?= h($r['user_role'] ?? '') ?>)</span></td>
            <td><b><?= h($r['event_text'] ?? '') ?></b></td>
            <td><?= h($r['module']) ?></td>
            <td><?= h($r['action']) ?></td>
            <td><?= h($r['table_name']) ?></td>
            <td><?= h($r['row_id']) ?></td>
            <td class="muted"><?= h($r['ip']) ?></td>
            <td class="muted" style="max-width:420px; white-space:pre-wrap;"><?= h($r['details']) ?></td>
          </tr>
        <?php endforeach; ?>
        <?php if (count($rows)===0): ?>
          <tr><td colspan="9" class="muted">Нет записей</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="hr"></div>

  <div class="card-head">
    <h2 class="h2">Файл logs/audit.log</h2>
    <div class="muted">последние строки</div>
  </div>

  <pre style="max-height:340px; overflow:auto; padding:12px; border-radius:12px; border:1px solid rgba(255,255,255,.12); background:rgba(0,0,0,.18);"><?= h($file_tail ?: 'Файл пока пуст или недоступен') ?></pre>
</section>
