<?php $tab='locations'; require __DIR__ . '/_tabs.php'; ?>

<div class="card">
  <div class="card-head">
    <h2 class="h2">Настройки → Локации / Цеха</h2>
    <div class="muted">удаление доступно (если нет привязок)</div>
  </div>

  <?php if (($_GET['err'] ?? '')==='loc_has_workshops'): ?>
    <div class="alert">Нельзя удалить локацию: у неё есть цеха. Сначала удалите/перенесите цеха.</div>
  <?php endif; ?>
  <?php if (($_GET['err'] ?? '')==='ws_has_data'): ?>
    <div class="alert">Нельзя удалить цех: есть привязки (работники или операции).</div>
  <?php endif; ?>

  <div class="grid-2" style="display:grid; grid-template-columns: 1fr 1fr; gap:14px;">
    <section class="card soft">
      <div class="card-head">
        <h2 class="h2">Локации</h2>
        <a class="btn primary" href="index.php?m=settings&a=location_edit">+ Создать</a>
      </div>

      <div class="table-wrap">
        <table>
          <thead>
            <tr>
              <th>Наименование</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($locations as $l): ?>
            <tr>
              <td><b><?= h($l['name']) ?></b></td>
              <td style="white-space:nowrap;">
                <a class="btn" href="index.php?m=settings&a=location_edit&id=<?= (int)$l['id'] ?>">Редактировать</a>
                <a class="btn danger" href="index.php?m=settings&a=location_delete&id=<?= (int)$l['id'] ?>" onclick="return confirm('Удалить локацию?')">Удалить</a>
              </td>
            </tr>
            <?php endforeach; ?>
            <?php if (count($locations)===0): ?>
            <tr><td colspan="2" class="muted">Нет данных</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </section>

    <section class="card soft">
      <div class="card-head">
        <h2 class="h2">Цеха</h2>
        <a class="btn primary" href="index.php?m=settings&a=workshop_edit">+ Создать</a>
      </div>

      <div class="small">Теперь при создании цеха можно не выбирать локацию — тогда цех с этим названием создастся во всех локациях (если его ещё нет).</div>

      <div class="table-wrap">
        <table>
          <thead>
            <tr>
              <th>Цех</th>
              <th>Локация</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($workshops as $w): ?>
            <tr>
              <td><b><?= h($w['name']) ?></b></td>
              <td class="muted"><?= h($w['location_name']) ?></td>
              <td style="white-space:nowrap;">
                <a class="btn" href="index.php?m=settings&a=workshop_edit&id=<?= (int)$w['id'] ?>">Редактировать</a>
                <a class="btn danger" href="index.php?m=settings&a=workshop_delete&id=<?= (int)$w['id'] ?>" onclick="return confirm('Удалить цех?')">Удалить</a>
              </td>
            </tr>
            <?php endforeach; ?>
            <?php if (count($workshops)===0): ?>
            <tr><td colspan="3" class="muted">Нет данных</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </section>
  </div>
</div>
