<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Качество (ОТК)</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">ОТК — контроль качества деталей</h2>
    <div class="muted">Ввод годных и брака по деталям. Эти данные используются в План/факт и на Дашборде.</div>
  </div>

  <?php if ($ok==='1'): ?>
    <div class="alert" style="border-color: rgba(25,195,125,.35);">Сохранено.</div>
  <?php endif; ?>
  <?php if (!empty($msg)): ?><div class="alert"><?= h($msg) ?></div><?php endif; ?>
  <?php if (($_GET['err'] ?? '')==='del'): ?><div class="alert">Для удаления нужна причина</div><?php endif; ?>

  <section class="card soft">
    <div class="card-head">
      <h2 class="h2">Добавить запись</h2>
      <div class="muted">Дата + локация + цех + деталь</div>
    </div>

    <form method="post">
      <div class="form-grid">
        <div class="field">
          <label>Дата*</label>
          <input type="date" name="qc_date" value="<?= h($today) ?>" required>
        </div>
        <div class="field">
          <label>Локация*</label>
          <select name="location_id" required onchange="location.href='index.php?m=quality&a=index&location_id='+this.value;">
            <?php foreach ($locations as $l): ?>
              <option value="<?= (int)$l['id'] ?>" <?= ((int)$location_id===(int)$l['id']?'selected':'') ?>><?= h($l['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="field">
          <label>Цех*</label>
          <select name="workshop_id" required onchange="location.href='index.php?m=quality&a=index&location_id=<?= (int)$location_id ?>&workshop_id='+this.value;">
            <option value="0">— выберите —</option>
            <?php foreach ($workshops as $w): ?>
              <option value="<?= (int)$w['id'] ?>" <?= ((int)$workshop_id===(int)$w['id']?'selected':'') ?>><?= h($w['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
      </div>

      <div class="form-grid" style="margin-top:12px;">
        <div class="field">
          <label>Деталь*</label>
          <select name="part_id" required>
            <option value="0">— выберите —</option>
            <?php foreach ($parts as $p): ?>
              <option value="<?= (int)$p['id'] ?>"><?= h($p['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="field">
          <label>Годных*</label>
          <input name="good_qty" value="0" required>
        </div>
        <div class="field">
          <label>Брак</label>
          <input name="bad_qty" value="0">
        </div>
      </div>

      <div class="field" style="margin-top:12px;">
        <label>Комментарий</label>
        <input name="comment" placeholder="например: партия 12">
      </div>

      <div class="actions" style="margin-top:12px;">
        <button class="btn primary" type="submit">Сохранить</button>
      </div>
    </form>
  </section>

  <div class="hr"></div>

  <section class="card soft">
    <div class="card-head">
      <h2 class="h2">Журнал ОТК</h2>
      <div class="muted">до 500 записей</div>
    </div>

    <form method="get" class="tabs" style="align-items:end;">
      <input type="hidden" name="m" value="quality">
      <input type="hidden" name="a" value="index">

      <div class="field">
        <label>Период: с</label>
        <input type="date" name="from" value="<?= h($date_from) ?>">
      </div>
      <div class="field">
        <label>по</label>
        <input type="date" name="to" value="<?= h($date_to) ?>">
      </div>
      <div class="field">
        <label>Локация</label>
        <select name="location_id">
          <option value="0">Все</option>
          <?php foreach ($locations as $l): ?>
            <option value="<?= (int)$l['id'] ?>" <?= ((int)$location_id===(int)$l['id']?'selected':'') ?>><?= h($l['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="field">
        <label>Цех</label>
        <select name="workshop_id">
          <option value="0">Все</option>
          <?php foreach ($workshops as $w): ?>
            <option value="<?= (int)$w['id'] ?>" <?= ((int)$workshop_id===(int)$w['id']?'selected':'') ?>><?= h($w['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="field">
        <label>Деталь</label>
        <select name="part_id">
          <option value="0">Все</option>
          <?php foreach ($parts as $p): ?>
            <option value="<?= (int)$p['id'] ?>" <?= ((int)$part_id===(int)$p['id']?'selected':'') ?>><?= h($p['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="actions">
        <button class="btn" type="submit">Показать</button>
      </div>
    </form>

    <div class="table-wrap" style="margin-top:10px;">
      <table>
        <thead>
          <tr>
            <th>Дата</th>
            <th>Локация</th>
            <th>Цех</th>
            <th>Деталь</th>
            <th>Годных</th>
            <th>Брак</th>
            <th>Комментарий</th>
            <th>Кто</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $r): ?>
            <tr>
              <td class="muted"><?= h($r['qc_date']) ?></td>
              <td><?= h($r['location_name']) ?></td>
              <td><?= h($r['workshop_name']) ?></td>
              <td><b><?= h($r['part_name']) ?></b></td>
              <td><?= h($r['good_qty']) ?></td>
              <td><?= h($r['bad_qty']) ?></td>
              <td class="muted"><?= h($r['comment']) ?></td>
              <td class="muted"><?= h($r['user_name'] ?? '') ?></td>
              <td style="white-space:nowrap; text-align:right;">
                <a class="btn sm" href="index.php?m=quality&a=edit&id=<?= (int)$r['id'] ?>">Изм.</a>
                <form method="post" action="index.php?m=quality&a=delete" style="display:inline-flex; gap:6px; align-items:center;">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <input name="reason" placeholder="Причина" style="max-width:160px;" required>
                  <button class="btn sm danger" type="submit" onclick="return confirm('Удалить запись ОТК?');">Удалить</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
          <?php if (count($rows)===0): ?>
            <tr><td colspan="9" class="muted">Нет данных</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </section>
</section>
