<?php $tab='assembly'; require __DIR__ . '/_tabs.php'; ?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Производство</span>
  <span class="crumb-sep">/</span>
  <span class="crumb">Комплектация изделия</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">Комплектация изделия (цех упаковки)</h2>
    <div class="muted">Списывает детали у цеха/сотрудника и добавляет готовую продукцию на склад локации</div>
  </div>

  <?php if (($_GET['ok'] ?? '')==='1'): ?>
    <div class="alert" style="border-color: rgba(25,195,125,.35);">Сборка сохранена. Готовая продукция поступила на склад.</div>
  <?php endif; ?>
  <?php if (!empty($msg)): ?><div class="alert"><?= h($msg) ?></div><?php endif; ?>

  <form method="get" class="tabs" style="align-items:center;">
    <input type="hidden" name="m" value="production">
    <input type="hidden" name="a" value="assembly">

    <select name="location_id" onchange="this.form.submit()">
      <?php foreach ($locations as $l): ?>
        <option value="<?= (int)$l['id'] ?>" <?= ((int)$location_id===(int)$l['id']?'selected':'') ?>><?= h($l['name']) ?></option>
      <?php endforeach; ?>
    </select>

    <select name="workshop_id" onchange="this.form.submit()">
      <?php foreach ($workshops as $w): ?>
        <option value="<?= (int)$w['id'] ?>" <?= ((int)$workshop_id===(int)$w['id']?'selected':'') ?>><?= h($w['name']) ?></option>
      <?php endforeach; ?>
    </select>

    <select name="product_id" onchange="this.form.submit()">
      <?php foreach ($products as $p): ?>
        <option value="<?= (int)$p['id'] ?>" <?= ((int)$product_id===(int)$p['id']?'selected':'') ?>><?= h($p['name']) ?></option>
      <?php endforeach; ?>
    </select>

    <span class="pill">Выбор изделия и цеха упаковки</span>
  </form>

  <div class="hr"></div>

  <section class="card soft">
    <div class="card-head">
      <h2 class="h2">Состав изделия</h2>
      <div class="muted">сколько деталей нужно на 1 изделие (из Настроек)</div>
    </div>

    <div class="table-wrap">
      <table>
        <thead>
          <tr>
            <th>Деталь</th>
            <th>На 1 изделие</th>
            <th>Доступно у источника</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($bom as $b): ?>
          <tr>
            <td><b><?= h($b['part_name']) ?></b></td>
            <td><?= h($b['qty_per_product']) ?></td>
            <td><?= h($avail[(int)$b['part_id']] ?? 0) ?></td>
          </tr>
          <?php endforeach; ?>
          <?php if (count($bom)===0): ?>
            <tr><td colspan="3" class="muted">У изделия не задан состав (Настройки → Готовая продукция)</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </section>

  <div class="hr"></div>

  <section class="card soft">
    <div class="card-head">
      <h2 class="h2">Собрать изделие</h2>
      <div class="muted">источник деталей: цех или сотрудник</div>
    </div>

    <form method="post">
      <input type="hidden" name="location_id" value="<?= (int)$location_id ?>">
      <input type="hidden" name="workshop_id" value="<?= (int)$workshop_id ?>">
      <input type="hidden" name="product_id" value="<?= (int)$product_id ?>">

      <div class="form-grid">
        <div class="field">
          <label>Источник деталей*</label>
          <select name="source_type" onchange="document.querySelectorAll('.src-ws,.src-emp').forEach(el=>el.style.display='none'); document.querySelector(this.value==='employee'?'.src-emp':'.src-ws').style.display='block';">
            <option value="workshop" <?= ($source_type==='workshop'?'selected':'') ?>>Цех</option>
            <option value="employee" <?= ($source_type==='employee'?'selected':'') ?>>Сотрудник</option>
          </select>
        </div>

        <div class="field src-ws" style="<?= ($source_type==='workshop'?'':'display:none;') ?>">
          <label>Цех-источник*</label>
          <select name="source_id">
            <?php foreach ($workshops as $w): ?>
              <option value="<?= (int)$w['id'] ?>" <?= ((int)$source_id===(int)$w['id']?'selected':'') ?>><?= h($w['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="field src-emp" style="<?= ($source_type==='employee'?'':'display:none;') ?>">
          <label>Сотрудник-источник*</label>
          <select name="source_id">
            <option value="0">— выберите —</option>
            <?php foreach ($employees as $e): ?>
              <option value="<?= (int)$e['id'] ?>" <?= ((int)$source_id===(int)$e['id']?'selected':'') ?>><?= h($e['full_name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
      </div>

      <div class="form-grid" style="margin-top:12px;">
        <div class="field">
          <label>Количество изделий*</label>
          <input name="qty" required placeholder="например: 5">
        </div>
        <div class="field">
          <label>Комментарий</label>
          <input name="comment" placeholder="например: смена 2">
        </div>
      </div>

      <div class="actions" style="margin-top:12px;">
        <button class="btn primary" type="submit" <?= (count($bom)===0?'disabled':'') ?>>Собрать</button>
        <a class="btn" href="index.php?m=warehouse&a=index&type=product&location_id=<?= (int)$location_id ?>">Открыть склад готовой продукции</a>
      </div>

      <div class="small" style="margin-top:10px;">
        Перед сборкой убедись, что детали получены на цех/сотрудника через “Склад готовых деталей”.
      </div>
    </form>
  </section>

  <div class="hr"></div>

  <section class="card soft">
    <div class="card-head">
      <h2 class="h2">История сборок (последние 50)</h2>
      <div class="muted">по текущей локации</div>
    </div>

    <div class="table-wrap">
      <table>
        <thead>
          <tr>
            <th>Дата</th>
            <th>Изделие</th>
            <th>Кол-во</th>
            <th>Цех</th>
            <th>Кто</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($history as $h): ?>
          <tr>
            <td class="muted"><?= h($h['created_at']) ?></td>
            <td><b><?= h($h['product_name']) ?></b></td>
            <td><?= h($h['qty']) ?></td>
            <td class="muted">
              <?php
                $wsn = '';
                foreach ($workshops as $w) { if ((int)$w['id']===(int)$h['workshop_id']) { $wsn=$w['name']; break; } }
                echo h($wsn);
              ?>
            </td>
            <td class="muted"><?= h($h['user_name'] ?? '') ?></td>
          </tr>
          <?php endforeach; ?>
          <?php if (count($history)===0): ?>
            <tr><td colspan="5" class="muted">Сборок пока нет</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </section>
</section>
