<?php $tab='parts'; require __DIR__ . '/_tabs.php'; ?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">План/факт</span>
  <span class="crumb-sep">/</span>
  <span class="crumb">Детали</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">План/факт по деталям</h2>
    <div class="muted">План = дневной план детали × количество дней периода. Факт (годных/брак) — из ОТК.</div>
  </div>

  <form method="get" class="tabs" style="align-items:end;">
    <input type="hidden" name="m" value="planfact">
    <input type="hidden" name="a" value="parts">

    <div class="field">
      <label>Период: с</label>
      <input type="date" name="from" value="<?= h($from) ?>">
    </div>
    <div class="field">
      <label>по</label>
      <input type="date" name="to" value="<?= h($to) ?>">
    </div>

    <div class="field">
      <label>Локация</label>
      <select name="location_id">
        <option value="0">Все</option>
        <?php foreach ($locations as $l): ?>
          <option value="<?= (int)$l['id'] ?>" <?= ((int)$location_id===(int)$l['id']?'selected':'') ?>><?= h($l['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>Цех</label>
      <select name="workshop_id">
        <option value="0">Все</option>
        <?php foreach ($workshops as $w): ?>
          <option value="<?= (int)$w['id'] ?>" <?= ((int)$workshop_id===(int)$w['id']?'selected':'') ?>><?= h($w['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>Деталь</label>
      <select name="part_id">
        <option value="0">Все</option>
        <?php foreach ($parts as $p): ?>
          <option value="<?= (int)$p['id'] ?>" <?= ((int)$part_id===(int)$p['id']?'selected':'') ?>><?= h($p['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="actions">
      <button class="btn" type="submit">Показать</button>
      <a class="btn" href="index.php?m=planfact&a=parts&from=<?= h(urlencode($from)) ?>&to=<?= h(urlencode($to)) ?>&location_id=<?= (int)$location_id ?>&workshop_id=<?= (int)$workshop_id ?>&part_id=<?= (int)$part_id ?>&export=1">Экспорт .xlsx</a>
    </div>
  </form>

  <div class="table-wrap" style="margin-top:12px;">
    <table>
      <thead>
        <tr>
          <th>Деталь</th>
          <th>Локация</th>
          <th>Цех</th>
          <th>План</th>
          <th>Факт</th>
          <th>Годных</th>
          <th>Брак</th>
          <th>% выполнения</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><b><?= h($r['part_name']) ?></b></td>
            <td><?= h($r['location_name']) ?></td>
            <td><?= h($r['workshop_name']) ?></td>
            <td><?= h($r['plan']) ?></td>
            <td><?= h($r['fact']) ?></td>
            <td><?= h($r['good']) ?></td>
            <td><?= h($r['bad']) ?></td>
            <td><?= h($r['pct']) ?>%</td>
          </tr>
        <?php endforeach; ?>
        <?php if (count($rows)===0): ?>
          <tr><td colspan="8" class="muted">Нет данных</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="small" style="margin-top:10px;">
    Дней в периоде: <b><?= (int)$days ?></b>
  </div>
</section>
