<?php
function tlink($type, $current){
  $cls = ($type===$current) ? 'tab active' : 'tab';
  $title = ($type==='material'?'Материал':($type==='tool'?'Инструмент':'Расходные материалы'));
  echo '<a class="'.$cls.'" href="index.php?m=materials&a=index&type='.h($type).'">'.h($title).'</a>';
}
?>
<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Материалы</span>
</div>

<div class="tabs">
  <?php tlink('material',$type); ?>
  <?php tlink('tool',$type); ?>
  <?php tlink('consumable',$type); ?>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2"><?= h($title) ?></h2>
    <div class="muted">CRUD + минимум/заказано по локациям</div>
  </div>

  <form method="get" class="tabs" style="align-items:center;">
    <input type="hidden" name="m" value="materials">
    <input type="hidden" name="a" value="index">
    <input type="hidden" name="type" value="<?= h($type) ?>">

    <select name="location_id">
      <option value="0">Локация: (не выбрано)</option>
      <?php foreach ($locations as $l): ?>
        <option value="<?= (int)$l['location_id'] ?>" <?= ((int)$location_id===(int)$l['location_id']?'selected':'') ?>>
          <?= h($l['location_name']) ?>
        </option>
      <?php endforeach; ?>
    </select>

    <select name="cat_id">
      <option value="0">Категория: все</option>
      <?php foreach ($cats as $c): ?>
        <option value="<?= (int)$c['id'] ?>" <?= ((int)$cat_id===(int)$c['id']?'selected':'') ?>>
          <?= h($c['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>

    <input name="q" placeholder="Поиск: название или код" value="<?= h($q) ?>">

    <button class="btn" type="submit">Показать</button>
    <a class="btn primary" href="index.php?m=materials&a=edit&type=<?= h($type) ?>">+ Добавить</a>
  </form>

  <div class="small" style="margin-top:10px;">
    Чтобы видеть колонки «Минимум/Заказано», выберите локацию в фильтре.
  </div>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Наименование</th>
          <th>Категория</th>
          <?php if ($has_unit): ?><th>Ед.</th><?php endif; ?>
          <th>Цена</th>
          <?php if ((int)$location_id>0): ?>
            <th>Минимум</th>
            <th>Заказано</th>
            <th>Ожидание</th>
          <?php endif; ?>
          <th>Статус</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($items as $it): ?>
        <tr>
          <td><b><?= h($it['name']) ?></b><div class="small"><?= h($it['code']) ?></div></td>
          <td class="muted"><?= h($it['category_name']) ?></td>
          <?php if ($has_unit): ?><td><?= h($it['unit']) ?></td><?php endif; ?>
          <td><?= $it['current_price']!==null ? h($it['current_price']) : '—' ?></td>

          <?php if ((int)$location_id>0): ?>
            <td><?= h($it['min_qty'] ?? '—') ?></td>
            <td>
              <?php if ((int)($it['is_ordered'] ?? 0)===1): ?>
                <span class="pill" style="color:var(--warn);">да (<?= h($it['ordered_qty']) ?>)</span>
              <?php else: ?>
                <span class="pill">нет</span>
              <?php endif; ?>
            </td>
            <td><?= !empty($it['expected_date']) ? h($it['expected_date']) : '—' ?></td>
          <?php endif; ?>

          <td>
            <?php if ((int)$it['is_active']===1): ?>
              <span class="pill" style="color:var(--ok);">активен</span>
            <?php else: ?>
              <span class="pill" style="color:var(--danger);">выкл</span>
            <?php endif; ?>
          </td>
          <td style="white-space:nowrap;">
            <a class="btn" href="index.php?m=materials&a=edit&type=<?= h($type) ?>&id=<?= (int)$it['id'] ?>">Редактировать</a>
            <a class="btn danger" href="index.php?m=materials&a=delete&type=<?= h($type) ?>&id=<?= (int)$it['id'] ?>" onclick="return confirm('Удалить? Лучше выключить (снимите активен) — но для MVP удаление разрешено. Продолжить?')">Удалить</a>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (count($items)===0): ?>
          <tr><td colspan="<?= (int)$location_id>0 ? (7 + ($has_unit?1:0)) : (4 + ($has_unit?1:0) + 2) ?>" class="muted">Нет данных</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</section>

<section class="card" style="margin-top:14px;">
  <div class="card-head">
    <h2 class="h2">Важно</h2>
    <div class="muted">как будет дальше</div>
  </div>
  <div class="muted">
    Этот модуль создаёт справочники и минимумы. Реальные остатки и приход/перемещения появятся в модуле «Склад».
  </div>
</section>
