<?php $tab='fot'; require __DIR__ . '/_tabs.php'; ?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Финансы</span>
  <span class="crumb-sep">/</span>
  <span class="crumb">ФОТ</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">ФОТ по операциям</h2>
    <div class="muted">Премии и штрафы учитываются отдельно. Для бригадира: оклад + % от выработки сотрудников цеха (без собственной выработки).</div>
  </div>

  <form method="get" class="tabs" style="align-items:end;">
    <input type="hidden" name="m" value="finance">
    <input type="hidden" name="a" value="fot">

    <div class="field">
      <label>Период: с</label>
      <input type="date" name="from" value="<?= h($from) ?>">
    </div>
    <div class="field">
      <label>по</label>
      <input type="date" name="to" value="<?= h($to) ?>">
    </div>

    <div class="field">
      <label>Локация</label>
      <select name="location_id">
        <option value="0">Все</option>
        <?php foreach ($locations as $l): ?>
          <option value="<?= (int)$l['id'] ?>" <?= ((int)$location_id===(int)$l['id']?'selected':'') ?>><?= h($l['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>Цех</label>
      <select name="workshop_id">
        <option value="0">Все</option>
        <?php foreach ($workshops as $w): ?>
          <option value="<?= (int)$w['id'] ?>" <?= ((int)$workshop_id===(int)$w['id']?'selected':'') ?>><?= h($w['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="actions">
      <button class="btn" type="submit">Показать</button>
      <a class="btn" href="index.php?m=finance&a=fot&from=<?= h(urlencode($from)) ?>&to=<?= h(urlencode($to)) ?>&location_id=<?= (int)$location_id ?>&workshop_id=<?= (int)$workshop_id ?>&export=1">Экспорт .xlsx</a>
    </div>
  </form>

  <div class="hr"></div>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Локация</th>
          <th>Цех</th>
          <th>Сотрудник</th>
          <th>Операции, ₽</th>
          <th>Премии, ₽</th>
          <th>Штрафы, ₽</th>
          <th>Бригадир, ₽</th>
          <th>Итого, ₽</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><?= h($r['location']) ?></td>
            <td><?= h($r['workshop']) ?></td>
            <td><b><?= h($r['employee']) ?></b></td>
            <td><?= h($r['ops_sum']) ?></td>
            <td><?= h($r['bonus']) ?></td>
            <td><?= h($r['penalty']) ?></td>
            <td><?= h($r['brig']) ?></td>
            <td><b><?= h($r['total']) ?></b></td>
          </tr>
        <?php endforeach; ?>
        <?php if (count($rows)===0): ?>
          <tr><td colspan="8" class="muted">Нет данных</td></tr>
        <?php endif; ?>
      </tbody>
      <tfoot>
        <tr>
          <th colspan="3" style="text-align:right;">ИТОГО</th>
          <th><?= h($totals['ops']) ?></th>
          <th><?= h($totals['bonus']) ?></th>
          <th><?= h($totals['penalty']) ?></th>
          <th><?= h($totals['brig']) ?></th>
          <th><?= h($totals['total']) ?></th>
        </tr>
      </tfoot>
    </table>
  </div>

  <div class="hr"></div>

  <div class="card-head">
    <h2 class="h2">Свод по локациям</h2>
    <div class="muted">итоги по выбранному периоду</div>
  </div>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Локация</th>
          <th>Операции, ₽</th>
          <th>Премии, ₽</th>
          <th>Штрафы, ₽</th>
          <th>Бригадир, ₽</th>
          <th>Итого, ₽</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($by_loc as $name=>$x): ?>
          <tr>
            <td><b><?= h($name) ?></b></td>
            <td><?= h(round($x['ops'],2)) ?></td>
            <td><?= h(round($x['bonus'],2)) ?></td>
            <td><?= h(round($x['penalty'],2)) ?></td>
            <td><?= h(round($x['brig'],2)) ?></td>
            <td><b><?= h(round($x['total'],2)) ?></b></td>
          </tr>
        <?php endforeach; ?>
        <?php if (count($by_loc)===0): ?>
          <tr><td colspan="6" class="muted">Нет данных</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</section>
