<?php
// views/dashboard/index.php
$stats = $stats ?? ['locations'=>0,'workshops'=>0,'employees'=>0,'prod_ops_qty'=>0];
$fot_by_loc = $fot_by_loc ?? [];
$low_materials = $low_materials ?? [];
$ready_products = $ready_products ?? [];
$shipped_month = $shipped_month ?? 0;
$reject_pct = $reject_pct ?? null;
$month_from = $month_from ?? date('Y-m-01');
$today = $today ?? date('Y-m-d');
?>

<div class="crumbs">
  <span class="crumb">Дашборд</span>
  <span class="crumb-sep">•</span>
  <span class="muted">период: <?= h($month_from) ?> — <?= h($today) ?></span>
</div>

<section class="grid-2">
  <div class="card">
    <div class="card-head">
      <h2 class="h2">Справочники</h2>
      <div class="muted">общее состояние системы</div>
    </div>

    <div class="kpis">
      <div class="kpi">
        <div class="kpi-title">Локации</div>
        <div class="kpi-value"><?= (int)($stats['locations'] ?? 0) ?></div>
      </div>
      <div class="kpi">
        <div class="kpi-title">Цеха</div>
        <div class="kpi-value"><?= (int)($stats['workshops'] ?? 0) ?></div>
      </div>
      <div class="kpi">
        <div class="kpi-title">Сотрудники</div>
        <div class="kpi-value"><?= (int)($stats['employees'] ?? 0) ?></div>
      </div>
      <div class="kpi">
        <div class="kpi-title">Операций (шт.)</div>
        <div class="kpi-value"><?= (int)($stats['prod_ops_qty'] ?? 0) ?></div>
      </div>
      <div class="kpi">
        <div class="kpi-title">% брака (месяц)</div>
        <div class="kpi-value"><?= $reject_pct===null ? '—' : h($reject_pct).'%' ?></div>
      </div>
      <div class="kpi">
        <div class="kpi-title">Отгружено (месяц)</div>
        <div class="kpi-value"><?= (int)$shipped_month ?></div>
      </div>
    </div>
  </div>

  <div class="card">
    <div class="card-head">
      <h2 class="h2">ФОТ по локациям</h2>
      <div class="muted">операции + премии − штрафы + бригадир</div>
    </div>

    <div class="table-wrap">
      <table>
        <thead>
          <tr>
            <th>Локация</th>
            <th>Операции</th>
            <th>Премии</th>
            <th>Штрафы</th>
            <th>Бригадир</th>
            <th>Итого</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($fot_by_loc as $r): ?>
            <tr>
              <td><b><?= h($r['location']) ?></b></td>
              <td><?= h($r['ops']) ?></td>
              <td><?= h($r['bonus']) ?></td>
              <td><?= h($r['penalty']) ?></td>
              <td><?= h($r['brig']) ?></td>
              <td><b><?= h($r['total']) ?></b></td>
            </tr>
          <?php endforeach; ?>
          <?php if (count($fot_by_loc)===0): ?>
            <tr><td colspan="6" class="muted">Нет данных</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <div class="actions" style="margin-top:10px;">
      <a class="btn" href="index.php?m=finance&a=fot">Открыть Финансы</a>
    </div>
  </div>
</section>

<section class="grid-2" style="margin-top:14px;">
  <div class="card">
    <div class="card-head">
      <h2 class="h2">Материалы с низким запасом</h2>
      <div class="muted">без “Заказано”</div>
    </div>

    <div class="table-wrap">
      <table>
        <thead>
          <tr>
            <th>Локация</th>
            <th>Материал</th>
            <th>Остаток</th>
            <th>Минимум</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($low_materials as $r): ?>
            <tr>
              <td><?= h($r['location_name'] ?? '') ?></td>
              <td><b><?= h($r['material_name'] ?? '') ?></b></td>
              <td><?= h($r['balance'] ?? '') ?></td>
              <td><?= h($r['minimum_qty'] ?? '') ?></td>
            </tr>
          <?php endforeach; ?>
          <?php if (count($low_materials)===0): ?>
            <tr><td colspan="4" class="muted">Нет данных (или минимум/движения ещё не настроены)</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <div class="card">
    <div class="card-head">
      <h2 class="h2">Готовая продукция к отгрузке</h2>
      <div class="muted">остатки по локациям</div>
    </div>

    <div class="table-wrap">
      <table>
        <thead>
          <tr>
            <th>Локация</th>
            <th>Кол-во</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($ready_products as $r): ?>
            <tr>
              <td><b><?= h($r['location_name'] ?? '') ?></b></td>
              <td><?= h($r['qty'] ?? 0) ?></td>
            </tr>
          <?php endforeach; ?>
          <?php if (count($ready_products)===0): ?>
            <tr><td colspan="2" class="muted">Нет данных</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <div class="actions" style="margin-top:10px;">
      <a class="btn" href="index.php?m=warehouse&a=products">Открыть склад готовой продукции</a>
    </div>
  </div>
</section>
