<?php
// modules/settings/operations.php — раздел "Операции" (Настройки)
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
require_once dirname(__DIR__, 2) . '/app/audit.php';

function settings_operations() {
    $u = require_role(['admin','director']);

    $location_id = (int)($_GET['location_id'] ?? 0);
    $workshop_id = (int)($_GET['workshop_id'] ?? 0);

    $locations = db_fetch_all(db_query("SELECT * FROM locations ORDER BY name"));
    $workshops = [];
    if ($location_id > 0) {
        $workshops = db_fetch_all(db_query("SELECT * FROM workshops WHERE location_id=$location_id ORDER BY name"));
    }

    $where = "1=1";
    if ($workshop_id > 0) $where .= " AND o.workshop_id=$workshop_id";

    $ops = db_fetch_all(db_query("
      SELECT o.*, w.name AS workshop_name, l.name AS location_name
      FROM operations o
      JOIN workshops w ON w.id=o.workshop_id
      JOIN locations l ON l.id=w.location_id
      WHERE $where
      ORDER BY l.name, w.name, o.name
    "));

    render('settings/operations_list', [
        'u'=>$u,
        'locations'=>$locations,
        'workshops'=>$workshops,
        'location_id'=>$location_id,
        'workshop_id'=>$workshop_id,
        'ops'=>$ops
    ]);
}

function settings_operation_edit() {
    $u = require_role(['admin','director']);

    $id = (int)($_GET['id'] ?? 0);

    $locations = db_fetch_all(db_query("SELECT * FROM locations ORDER BY name"));
    $selected_location_id = 0;
    $workshops = [];

    $item = null;
    $opi = [];

    if ($id > 0) {
        $item = db_fetch_one(db_query("SELECT * FROM operations WHERE id=$id LIMIT 1"));
        if (!$item) { http_response_code(404); echo "Операция не найдена"; exit; }

        $ws = db_fetch_one(db_query("SELECT * FROM workshops WHERE id=".(int)$item['workshop_id']." LIMIT 1"));
        $selected_location_id = $ws ? (int)$ws['location_id'] : 0;
        if ($selected_location_id > 0) {
            $workshops = db_fetch_all(db_query("SELECT * FROM workshops WHERE location_id=$selected_location_id ORDER BY name"));
        }

        $opi = db_fetch_all(db_query("
          SELECT oi.*, 
                 m.name AS material_name,
                 c.name AS consumable_name
          FROM operation_items oi
          LEFT JOIN materials m ON (oi.item_type='material' AND m.id=oi.item_id)
          LEFT JOIN consumables c ON (oi.item_type='consumable' AND c.id=oi.item_id)
          WHERE oi.operation_id=$id
          ORDER BY oi.id
        "));
    }

    // для выбора в форме
    $materials = db_fetch_all(db_query("SELECT id, name FROM materials WHERE is_active=1 ORDER BY name"));
    $consumables = db_fetch_all(db_query("SELECT id, name FROM consumables WHERE is_active=1 ORDER BY name"));

    $msg = '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $location_id = (int)($_POST['location_id'] ?? 0);
        $workshop_id = (int)($_POST['workshop_id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $price = str_replace(',', '.', trim($_POST['price'] ?? '0'));
        $defcoef = str_replace(',', '.', trim($_POST['defect_coef_pct'] ?? '0'));
        $daily_plan = (int)($_POST['daily_plan_per_employee'] ?? 0);
        $desc = trim($_POST['description'] ?? '');
        $is_active = isset($_POST['is_active']) ? 1 : 0;

        $row_type = $_POST['row_type'] ?? [];
        $row_item = $_POST['row_item'] ?? [];
        $row_qty = $_POST['row_qty'] ?? [];

        if ($location_id<=0 || $workshop_id<=0) $msg='Выберите локацию и цех';
        else if ($name === '') $msg='Название операции обязательно';
        else if (!is_numeric($price)) $msg='Цена должна быть числом';
        else if (!is_numeric($defcoef)) $msg='Коэффициент брака должен быть числом';
        else {
            $name_esc = db_escape($name);
            $desc_esc = db_escape($desc);
            $price_f = (float)$price;
            $def_f = (float)$defcoef;

            if ($id > 0) {
                db_query("UPDATE operations SET name='$name_esc', workshop_id=$workshop_id, price=$price_f, defect_coef_pct=$def_f, daily_plan_per_employee=$daily_plan, description='$desc_esc', is_active=$is_active WHERE id=$id");
                audit('UPDATE','operations',$id,(int)$u['id'], ['name'=>$name,'workshop_id'=>$workshop_id,'price'=>$price_f]);
                db_query("DELETE FROM operation_items WHERE operation_id=$id");
            } else {
                db_query("INSERT INTO operations(name,workshop_id,price,defect_coef_pct,daily_plan_per_employee,description,is_active,created_at)
                          VALUES ('$name_esc',$workshop_id,$price_f,$def_f,$daily_plan,'$desc_esc',$is_active,NOW())");
                $id = (int)db_last_id();
                audit('CREATE','operations',$id,(int)$u['id'], ['name'=>$name,'workshop_id'=>$workshop_id,'price'=>$price_f]);
            }

            // сохранить спецификацию материалов/расходников
            for ($i=0; $i<count($row_type); $i++) {
                $t = $row_type[$i] ?? '';
                $iid = (int)($row_item[$i] ?? 0);
                $q = str_replace(',', '.', trim($row_qty[$i] ?? '0'));

                if (!in_array($t, ['material','consumable'], true)) continue;
                if ($iid<=0) continue;
                if (!is_numeric($q) || (float)$q<=0) continue;

                $t_esc = db_escape($t);
                $q_f = (float)$q;
                db_query("INSERT INTO operation_items(operation_id,item_type,item_id,qty_per_op) VALUES ($id,'$t_esc',$iid,$q_f)");
            }

            header('Location: index.php?m=settings&a=operations');
            exit;
        }

        // for rerender dropdown
        $selected_location_id = $location_id;
        if ($selected_location_id > 0) {
            $workshops = db_fetch_all(db_query("SELECT * FROM workshops WHERE location_id=$selected_location_id ORDER BY name"));
        }
        $item = [
            'id'=>$id,'name'=>$name,'workshop_id'=>$workshop_id,'price'=>$price,'defect_coef_pct'=>$defcoef,
            'daily_plan_per_employee'=>$daily_plan,'description'=>$desc,'is_active'=>$is_active
        ];
    }

    render('settings/operation_edit', [
        'u'=>$u,
        'id'=>$id,
        'item'=>$item,
        'msg'=>$msg,
        'locations'=>$locations,
        'workshops'=>$workshops,
        'selected_location_id'=>$selected_location_id,
        'materials'=>$materials,
        'consumables'=>$consumables,
        'opi'=>$opi
    ]);
}

function settings_operation_delete() {
    $u = require_role(['admin','director']);
    $id = (int)($_GET['id'] ?? 0);
    if ($id<=0) { header('Location: index.php?m=settings&a=operations'); exit; }

    db_query("DELETE FROM operation_items WHERE operation_id=$id");
    db_query("DELETE FROM operations WHERE id=$id");
    audit('DELETE','operations',$id,(int)$u['id'], null);

    header('Location: index.php?m=settings&a=operations');
    exit;
}
