<?php
// modules/dashboard/controller.php
// FIX: Дашборд доступен только admin/director.
// Для остальных ролей при прямом заходе на ?m=dashboard делаем редирект на их "домашний" модуль,
// чтобы не показывать "доступ запрещён" на главной.

if (!function_exists('dash_table_exists')) {
function dash_table_exists($table) {
    $t = db_escape($table);
    $r = db_fetch_one(db_query("SELECT 1 x FROM information_schema.tables WHERE table_schema=DATABASE() AND table_name='$t' LIMIT 1"));
    return !empty($r);
}
}

if (!function_exists('dashboard__redirect_home')) {
function dashboard__redirect_home($role) {
    // Домашние страницы по ролям
    if ($role === 'brigadier')   return 'index.php?m=production&a=index';
    if ($role === 'storekeeper') return 'index.php?m=warehouse&a=index';
    if ($role === 'otk')         return 'index.php?m=quality&a=index';
    if ($role === 'prod_head')   return 'index.php?m=production&a=index';
    // по умолчанию — на склад (самый безопасный общий)
    return 'index.php?m=warehouse&a=index';
}
}

if (!function_exists('dashboard_index')) {
function dashboard_index() {
    $u = require_login();

    $role = $u['role'] ?? '';
    if (!in_array($role, ['admin','director'], true)) {
        header('Location: ' . dashboard__redirect_home($role));
        exit;
    }

    // Далее — сбор показателей (бережно: только если таблицы существуют)
    $cnt_locations = 0;
    $cnt_workshops = 0;
    $cnt_employees = 0;
    $cnt_ops = 0;
    $cnt_parts = 0;

    if (dash_table_exists('locations')) {
        $r = db_fetch_one(db_query("SELECT COUNT(*) c FROM locations"));
        $cnt_locations = (int)($r['c'] ?? 0);
    }
    if (dash_table_exists('workshops')) {
        $r = db_fetch_one(db_query("SELECT COUNT(*) c FROM workshops"));
        $cnt_workshops = (int)($r['c'] ?? 0);
    }
    if (dash_table_exists('employees')) {
        $r = db_fetch_one(db_query("SELECT COUNT(*) c FROM employees WHERE is_active=1"));
        $cnt_employees = (int)($r['c'] ?? 0);
    }
    if (dash_table_exists('operation_logs')) {
        $r = db_fetch_one(db_query("SELECT COUNT(*) c FROM operation_logs"));
        $cnt_ops = (int)($r['c'] ?? 0);
    }
    if (dash_table_exists('parts')) {
        $r = db_fetch_one(db_query("SELECT COUNT(*) c FROM parts"));
        $cnt_parts = (int)($r['c'] ?? 0);
    }

    render('dashboard/index', [
        'u' => $u,
        'cnt_locations' => $cnt_locations,
        'cnt_workshops' => $cnt_workshops,
        'cnt_employees' => $cnt_employees,
        'cnt_ops' => $cnt_ops,
        'cnt_parts' => $cnt_parts,
    ]);
}
}
