-- db/update_016_transfer_routes.sql
SET NAMES utf8mb4;

CREATE TABLE IF NOT EXISTS transfer_routes (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  location_id INT UNSIGNED NOT NULL,
  from_workshop_id INT UNSIGNED NOT NULL,
  to_workshop_id INT UNSIGNED NOT NULL,
  created_at DATETIME NOT NULL,
  created_by INT UNSIGNED NOT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY uq_route (location_id, from_workshop_id, to_workshop_id),
  KEY idx_loc (location_id),
  KEY idx_from (from_workshop_id),
  KEY idx_to (to_workshop_id),
  CONSTRAINT fk_routes_loc FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE RESTRICT,
  CONSTRAINT fk_routes_from_ws FOREIGN KEY (from_workshop_id) REFERENCES workshops(id) ON DELETE RESTRICT,
  CONSTRAINT fk_routes_to_ws FOREIGN KEY (to_workshop_id) REFERENCES workshops(id) ON DELETE RESTRICT,
  CONSTRAINT fk_routes_user FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
