-- db/update_012_staff_tools_badge.sql
-- Персонал: фото, история инструмента, события выдачи/возврата/списания
SET NAMES utf8mb4;

ALTER TABLE employees
  ADD COLUMN photo_path VARCHAR(255) NOT NULL DEFAULT '' AFTER hired_date;

CREATE TABLE IF NOT EXISTS employee_tool_events (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  event_type ENUM('issue','return','writeoff') NOT NULL,
  employee_id INT UNSIGNED NOT NULL,
  tool_id INT UNSIGNED NOT NULL,
  qty DECIMAL(14,3) NOT NULL DEFAULT 1,
  location_id INT UNSIGNED NOT NULL,
  workshop_id INT UNSIGNED NOT NULL DEFAULT 0,
  reason VARCHAR(255) NOT NULL DEFAULT '',
  comment TEXT,
  created_at DATETIME NOT NULL,
  created_by INT UNSIGNED NOT NULL,
  PRIMARY KEY (id),
  KEY idx_ete_emp (employee_id),
  KEY idx_ete_tool (tool_id),
  KEY idx_ete_dt (created_at),
  CONSTRAINT fk_ete_emp FOREIGN KEY (employee_id) REFERENCES employees(id) ON DELETE RESTRICT,
  CONSTRAINT fk_ete_tool FOREIGN KEY (tool_id) REFERENCES tools(id) ON DELETE RESTRICT,
  CONSTRAINT fk_ete_loc FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE RESTRICT,
  CONSTRAINT fk_ete_user FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
