-- db/update_010_telegram.sql
-- Telegram: настройки бота, уведомления по ролям, лог отправок, антиспам для низкого остатка
SET NAMES utf8mb4;

CREATE TABLE IF NOT EXISTS app_settings (
  `key` VARCHAR(120) NOT NULL,
  `value` TEXT,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS telegram_notifications (
  code VARCHAR(64) NOT NULL,
  title VARCHAR(255) NOT NULL,
  PRIMARY KEY (code)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS telegram_notification_roles (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  notification_code VARCHAR(64) NOT NULL,
  role VARCHAR(64) NOT NULL,
  is_enabled TINYINT(1) NOT NULL DEFAULT 0,
  send_time TIME DEFAULT NULL, -- только для ежедневного отчета
  PRIMARY KEY (id),
  UNIQUE KEY uq_tnr (notification_code, role),
  CONSTRAINT fk_tnr_notif FOREIGN KEY (notification_code) REFERENCES telegram_notifications(code) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS telegram_send_log (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  notification_code VARCHAR(64) NOT NULL,
  target VARCHAR(64) NOT NULL, -- role/user/system
  target_value VARCHAR(128) NOT NULL DEFAULT '',
  sent_at DATETIME NOT NULL,
  meta TEXT,
  PRIMARY KEY (id),
  KEY idx_tsl_code_dt (notification_code, sent_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS low_stock_state (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  item_type ENUM('material','tool','consumable') NOT NULL,
  item_id INT UNSIGNED NOT NULL,
  location_id INT UNSIGNED NOT NULL,
  state ENUM('ok','low') NOT NULL DEFAULT 'ok',
  updated_at DATETIME NOT NULL,
  PRIMARY KEY (id),
  UNIQUE KEY uq_lss (item_type, item_id, location_id),
  KEY idx_lss_loc (location_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT IGNORE INTO telegram_notifications(code,title) VALUES
('low_stock','Низкий остаток'),
('daily_products','Ежедневный отчёт по готовым изделиям');

-- Настройки по ролям (по умолчанию выключено)
INSERT IGNORE INTO telegram_notification_roles(notification_code, role, is_enabled, send_time) VALUES
('low_stock','admin',0,NULL),
('low_stock','director',0,NULL),
('low_stock','prod_head',0,NULL),
('low_stock','brigadier',0,NULL),
('low_stock','storekeeper',0,NULL),
('low_stock','otk',0,NULL),

('daily_products','admin',0,'19:00:00'),
('daily_products','director',1,'19:00:00'),
('daily_products','prod_head',0,'19:00:00'),
('daily_products','brigadier',0,'19:00:00'),
('daily_products','storekeeper',0,'19:00:00'),
('daily_products','otk',0,'19:00:00');
