-- db/update_007_product_warehouse.sql
-- Склад готовой продукции: журнал движений + отгрузки + строки отгрузки
SET NAMES utf8mb4;

CREATE TABLE IF NOT EXISTS product_moves (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  location_id INT UNSIGNED NOT NULL,
  product_id INT UNSIGNED NOT NULL,
  move_type ENUM('in','ship','adjust','reverse') NOT NULL,
  qty DECIMAL(14,3) NOT NULL DEFAULT 0, -- положительное число
  reason VARCHAR(255) NOT NULL DEFAULT '',
  comment TEXT,
  is_reversed TINYINT(1) NOT NULL DEFAULT 0,
  reversed_of BIGINT UNSIGNED DEFAULT NULL,
  created_at DATETIME NOT NULL,
  created_by INT UNSIGNED NOT NULL,
  PRIMARY KEY (id),
  KEY idx_pm_loc (location_id),
  KEY idx_pm_prod (product_id),
  KEY idx_pm_dt (created_at),
  KEY idx_pm_rev (reversed_of),
  CONSTRAINT fk_pm_loc FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE CASCADE,
  CONSTRAINT fk_pm_prod FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE RESTRICT,
  CONSTRAINT fk_pm_user FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS product_shipments (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  location_id INT UNSIGNED NOT NULL,
  customer VARCHAR(255) NOT NULL DEFAULT '',
  doc_no VARCHAR(128) NOT NULL DEFAULT '',
  comment TEXT,
  shipped_at DATETIME NOT NULL,
  created_by INT UNSIGNED NOT NULL,
  is_canceled TINYINT(1) NOT NULL DEFAULT 0,
  canceled_at DATETIME DEFAULT NULL,
  canceled_by INT UNSIGNED DEFAULT NULL,
  cancel_reason VARCHAR(255) NOT NULL DEFAULT '',
  PRIMARY KEY (id),
  KEY idx_ps_loc (location_id),
  KEY idx_ps_dt (shipped_at),
  CONSTRAINT fk_ps_loc FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE CASCADE,
  CONSTRAINT fk_ps_user FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS product_shipment_items (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  shipment_id BIGINT UNSIGNED NOT NULL,
  product_id INT UNSIGNED NOT NULL,
  qty DECIMAL(14,3) NOT NULL DEFAULT 0,
  move_id BIGINT UNSIGNED DEFAULT NULL,
  PRIMARY KEY (id),
  KEY idx_psi_ship (shipment_id),
  KEY idx_psi_prod (product_id),
  CONSTRAINT fk_psi_ship FOREIGN KEY (shipment_id) REFERENCES product_shipments(id) ON DELETE CASCADE,
  CONSTRAINT fk_psi_prod FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE RESTRICT,
  CONSTRAINT fk_psi_move FOREIGN KEY (move_id) REFERENCES product_moves(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
