-- db/update_003_operations_production.sql
-- Операции + списание материалов по выработке + минимальная таблица работников (для выбора в выработке)
SET NAMES utf8mb4;

-- Минимальная таблица работников (позже расширим фото/телефон/бейдж и т.п.)
CREATE TABLE IF NOT EXISTS employees (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  emp_no VARCHAR(64) NOT NULL DEFAULT '',
  full_name VARCHAR(255) NOT NULL,
  phone VARCHAR(64) NOT NULL DEFAULT '',
  birth_date DATE DEFAULT NULL,
  hired_date DATE DEFAULT NULL,
  location_id INT UNSIGNED NOT NULL,
  workshop_id INT UNSIGNED NOT NULL,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL,
  PRIMARY KEY (id),
  KEY idx_emp_loc (location_id),
  KEY idx_emp_ws (workshop_id),
  KEY idx_emp_name (full_name),
  CONSTRAINT fk_emp_loc FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE RESTRICT,
  CONSTRAINT fk_emp_ws FOREIGN KEY (workshop_id) REFERENCES workshops(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Операции
CREATE TABLE IF NOT EXISTS operations (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  name VARCHAR(255) NOT NULL,
  workshop_id INT UNSIGNED NOT NULL,
  price DECIMAL(12,2) NOT NULL DEFAULT 0,
  defect_coef_pct DECIMAL(7,2) NOT NULL DEFAULT 0, -- % коэффициент для цены с браком (на будущее)
  daily_plan_per_employee INT UNSIGNED NOT NULL DEFAULT 0,
  description TEXT,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL,
  PRIMARY KEY (id),
  KEY idx_op_ws (workshop_id),
  UNIQUE KEY uq_op_name_ws (workshop_id, name),
  CONSTRAINT fk_op_ws FOREIGN KEY (workshop_id) REFERENCES workshops(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Материалы/расходники на операцию (что нужно и сколько на 1 операцию)
CREATE TABLE IF NOT EXISTS operation_items (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  operation_id INT UNSIGNED NOT NULL,
  item_type ENUM('material','consumable') NOT NULL,
  item_id INT UNSIGNED NOT NULL,
  qty_per_op DECIMAL(14,3) NOT NULL DEFAULT 0,
  PRIMARY KEY (id),
  KEY idx_opi_op (operation_id),
  KEY idx_opi_item (item_type, item_id),
  CONSTRAINT fk_opi_op FOREIGN KEY (operation_id) REFERENCES operations(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Журнал выработки (учёт производительности)
CREATE TABLE IF NOT EXISTS production_logs (
  id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
  work_date DATE NOT NULL,
  location_id INT UNSIGNED NOT NULL,
  workshop_id INT UNSIGNED NOT NULL,
  employee_id INT UNSIGNED NOT NULL,
  operation_id INT UNSIGNED NOT NULL,
  qty INT UNSIGNED NOT NULL DEFAULT 0,
  price_at_time DECIMAL(12,2) NOT NULL DEFAULT 0,
  amount DECIMAL(14,2) NOT NULL DEFAULT 0,
  created_at DATETIME NOT NULL,
  created_by INT UNSIGNED NOT NULL,
  PRIMARY KEY (id),
  KEY idx_pl_dt (work_date),
  KEY idx_pl_loc (location_id),
  KEY idx_pl_ws (workshop_id),
  KEY idx_pl_emp (employee_id),
  KEY idx_pl_op (operation_id),
  CONSTRAINT fk_pl_loc FOREIGN KEY (location_id) REFERENCES locations(id) ON DELETE RESTRICT,
  CONSTRAINT fk_pl_ws FOREIGN KEY (workshop_id) REFERENCES workshops(id) ON DELETE RESTRICT,
  CONSTRAINT fk_pl_emp FOREIGN KEY (employee_id) REFERENCES employees(id) ON DELETE RESTRICT,
  CONSTRAINT fk_pl_op FOREIGN KEY (operation_id) REFERENCES operations(id) ON DELETE RESTRICT,
  CONSTRAINT fk_pl_user FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
