<?php
// app/telegram_debug.php — диагностика отправки Telegram
require_once __DIR__ . '/telegram.php';

function tg_send_message_debug($chat_id, $text) {
    $token = trim(app_setting_get('telegram_bot_token',''));
    if ($token==='') {
        return ['ok'=>false,'err'=>'token_empty'];
    }
    $chat_id = trim((string)$chat_id);
    if ($chat_id==='') {
        return ['ok'=>false,'err'=>'chat_id_empty'];
    }

    $url = "https://api.telegram.org/bot".$token."/sendMessage";
    $post = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => 1,
    ];

    if (!function_exists('curl_init')) {
        return ['ok'=>false,'err'=>'curl_not_available'];
    }

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 8);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);

    $resp = curl_exec($ch);
    $curl_errno = curl_errno($ch);
    $curl_err = curl_error($ch);
    $http = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    $data = null;
    if ($resp !== false) {
        $data = json_decode($resp, true);
    }

    return [
        'ok' => ($http>=200 && $http<300 && is_array($data) && !empty($data['ok'])),
        'http' => $http,
        'curl_errno' => $curl_errno,
        'curl_error' => $curl_err,
        'response_raw' => $resp,
        'response_json' => $data,
    ];
}
