<?php
require_once __DIR__ . '/telegram.php';

if (!function_exists('tg_get_recipients')) {

function tg_get_recipients($notif_key) {
    $k = db_escape($notif_key);

    $users = db_fetch_all(db_query("SELECT id, full_name, role, telegram_id FROM users WHERE is_active=1 AND telegram_id<>''"));

    $role_rows = db_fetch_all(db_query("SELECT role,is_enabled,send_time FROM tg_notify_role WHERE notif_key='$k'"));
    $rp = [];
    foreach ($role_rows as $r) $rp[$r['role']] = $r;

    $user_rows = db_fetch_all(db_query("SELECT user_id,is_enabled,send_time FROM tg_notify_user WHERE notif_key='$k'"));
    $up = [];
    foreach ($user_rows as $r) $up[(int)$r['user_id']] = $r;

    $out = [];
    foreach ($users as $u) {
        $uid = (int)$u['id'];
        $role = (string)$u['role'];

        $en = 0; $tm = null;
        if (isset($up[$uid])) { $en = (int)$up[$uid]['is_enabled']; $tm = $up[$uid]['send_time']; }
        else if (isset($rp[$role])) { $en = (int)$rp[$role]['is_enabled']; $tm = $rp[$role]['send_time']; }

        if ($en !== 1) continue;

        $out[] = ['id'=>$uid,'role'=>$role,'name'=>$u['full_name'],'telegram_id'=>$u['telegram_id'],'send_time'=>$tm];
    }
    return $out;
}

function tg_state_sent_today($notif_key, $uid) {
    $k = db_escape($notif_key);
    $uid = (int)$uid;
    $r = db_fetch_one(db_query("SELECT last_sent_date FROM tg_notify_state WHERE notif_key='$k' AND user_id=$uid LIMIT 1"));
    return isset($r['last_sent_date']) && $r['last_sent_date'] === date('Y-m-d');
}

function tg_state_mark_sent($notif_key, $uid) {
    $k = db_escape($notif_key);
    $uid = (int)$uid;
    $d = date('Y-m-d');
    db_query("INSERT INTO tg_notify_state(notif_key,user_id,last_sent_date) VALUES('$k',$uid,'$d')
              ON DUPLICATE KEY UPDATE last_sent_date=VALUES(last_sent_date)");
}

function notify_daily_products($cron_mode=false) {
    $today = date('Y-m-d');
    $total = 0;
    $by_loc = [];

    $has = db_fetch_one(db_query("SELECT 1 x FROM information_schema.tables WHERE table_schema=DATABASE() AND table_name='assemblies' LIMIT 1"));
    if (!$has) return false;

    $rows = db_fetch_all(db_query("SELECT location_id, SUM(qty) s FROM assemblies WHERE assembly_date='$today' GROUP BY location_id"));
    foreach ($rows as $r) { $loc=(int)$r['location_id']; $qty=(int)$r['s']; $by_loc[$loc]=$qty; $total+=$qty; }

    $loc_names = [];
    if (count($by_loc)>0) {
        $ids = implode(',', array_map('intval', array_keys($by_loc)));
        $lr = db_fetch_all(db_query("SELECT id,name FROM locations WHERE id IN ($ids)"));
        foreach ($lr as $r) $loc_names[(int)$r['id']] = $r['name'];
    }

    $lines = [];
    $lines[] = "Ежедневный отчёт: готовые изделия";
    $lines[] = "Дата: ".date('d.m.Y');
    $lines[] = "Итого: ".$total;
    if ($total>0) {
        $lines[] = "";
        foreach ($by_loc as $loc=>$qty) $lines[] = ($loc_names[$loc] ?? ("Локация #".$loc)).": ".$qty;
    }
    $text = implode("\n", $lines);

    foreach (tg_get_recipients('daily_products') as $r) {
        if ($cron_mode) {
            $tm = $r['send_time'];
            if (!$tm) continue;
            $now = date('H:i');
            $t = substr((string)$tm,0,5);
            if ($now < $t) continue;
            if (tg_state_sent_today('daily_products', $r['id'])) continue;
        }
        tg_send_message($r['telegram_id'], $text);
        if ($cron_mode) tg_state_mark_sent('daily_products', $r['id']);
    }

    return true;
}

}
