<?php require __DIR__ . '/_tabs.php'; ?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <a class="crumb" href="index.php?m=warehouse&a=index&type=product&location_id=<?= (int)$location_id ?>">Готовая продукция</a>
  <span class="crumb-sep">/</span>
  <span class="crumb"><?= h($product['name']) ?></span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2"><?= h($product['name']) ?></h2>
    <div class="badge">Остаток: <?= h($bal) ?></div>
  </div>

  <?php if (($_GET['err'] ?? '')==='qty'): ?>
    <div class="alert">Укажите корректное количество для отгрузки.</div>
  <?php elseif (($_GET['err'] ?? '')==='bal'): ?>
    <div class="alert">Недостаточно остатка для отгрузки (проверь склад).</div>
  <?php elseif (($_GET['ok'] ?? '')==='1'): ?>
    <div class="alert" style="border-color: rgba(25,195,125,.35);">Отгрузка сохранена.</div>
  <?php elseif (($_GET['ok'] ?? '')==='cancel'): ?>
    <div class="alert" style="border-color: rgba(245,165,36,.45);">Отгрузка отменена (остаток восстановлен).</div>
  <?php endif; ?>

  <section class="card soft">
    <div class="card-head">
      <h2 class="h2">Отгрузка</h2>
      <div class="muted">списывает готовую продукцию со склада локации</div>
    </div>

    <form method="post" action="index.php?m=warehouse&a=product_ship">
      <input type="hidden" name="location_id" value="<?= (int)$location_id ?>">
      <input type="hidden" name="product_id" value="<?= (int)$product['id'] ?>">

      <div class="form-grid">
        <div class="field">
          <label>Количество*</label>
          <input name="qty" required placeholder="например: 10">
        </div>
        <div class="field">
          <label>Покупатель (не обязательно)</label>
          <input name="customer" placeholder="текст">
        </div>
      </div>

      <div class="form-grid" style="margin-top:12px;">
        <div class="field">
          <label>Накладная/документ № (не обязательно)</label>
          <input name="doc_no" placeholder="например: 123/01">
        </div>
        <div class="field">
          <label>Комментарий</label>
          <input name="comment" placeholder="например: отгрузка по заявке">
        </div>
      </div>

      <div class="actions" style="margin-top:12px;">
        <button class="btn primary" type="submit">Отгрузить</button>
        <a class="btn" href="index.php?m=warehouse&a=index&type=product&location_id=<?= (int)$location_id ?>">Назад</a>
      </div>
    </form>
  </section>

  <div class="hr"></div>

  <section class="card soft">
    <div class="card-head">
      <h2 class="h2">История отгрузок (последние 100)</h2>
      <div class="muted">можно отменять</div>
    </div>

    <div class="table-wrap">
      <table>
        <thead>
          <tr>
            <th>Дата</th>
            <th>Кол-во</th>
            <th>Покупатель</th>
            <th>Документ</th>
            <th>Кто</th>
            <th>Статус</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($history as $h): ?>
          <tr>
            <td class="muted"><?= h($h['shipped_at']) ?></td>
            <td><b><?= h($h['qty']) ?></b></td>
            <td><?= h($h['customer']) ?></td>
            <td class="muted"><?= h($h['doc_no']) ?></td>
            <td class="muted"><?= h($h['user_name'] ?? '') ?></td>
            <td>
              <?php if ((int)$h['is_canceled']===1): ?>
                <span class="pill" style="color:var(--warn);">отменено</span>
              <?php else: ?>
                <span class="pill" style="color:var(--ok);">выполнено</span>
              <?php endif; ?>
            </td>
            <td style="white-space:nowrap;">
              <?php if ((int)$h['is_canceled']===0 && in_array($u['role'], ['admin','director','storekeeper'], true)): ?>
                <form method="post" action="index.php?m=warehouse&a=product_cancel" style="display:inline-flex; gap:8px; align-items:center;">
                  <input type="hidden" name="shipment_id" value="<?= (int)$h['id'] ?>">
                  <input type="hidden" name="location_id" value="<?= (int)$location_id ?>">
                  <input type="hidden" name="product_id" value="<?= (int)$product['id'] ?>">
                  <input name="reason" placeholder="Причина отмены" style="max-width:220px;">
                  <button class="btn danger" type="submit" onclick="return confirm('Отменить отгрузку? Остаток будет восстановлен.')">Отменить</button>
                </form>
              <?php else: ?>
                <span class="muted">—</span>
              <?php endif; ?>
            </td>
          </tr>
          <?php endforeach; ?>
          <?php if (count($history)===0): ?>
            <tr><td colspan="7" class="muted">Отгрузок пока нет</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </section>
</section>
