<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <a class="crumb" href="index.php?m=warehouse&a=index&type=<?= h($type) ?>&location_id=<?= (int)$location_id ?>">Склад</a>
  <span class="crumb-sep">/</span>
  <span class="crumb"><?= h($item['name']) ?></span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2"><?= h($item['name']) ?></h2>
    <div class="muted">локация #<?= (int)$location_id ?></div>
  </div>

  <div class="actions">
    <a class="btn primary" href="index.php?m=warehouse&a=receipt&type=<?= h($type) ?>&location_id=<?= (int)$location_id ?>">+ Приход</a>
    <a class="btn" href="index.php?m=warehouse&a=transfer&type=<?= h($type) ?>&location_id=<?= (int)$location_id ?>">Перемещение</a>
    <a class="btn" href="index.php?m=warehouse&a=adjust&type=<?= h($type) ?>&location_id=<?= (int)$location_id ?>">Корректировка</a>
    <?php if (in_array($type, ['tool','consumable'], true)): ?>
      <a class="btn danger" href="index.php?m=warehouse&a=writeoff&type=<?= h($type) ?>&location_id=<?= (int)$location_id ?>">Списать</a>
    <?php endif; ?>
    <a class="btn" href="index.php?m=warehouse&a=index&type=<?= h($type) ?>&location_id=<?= (int)$location_id ?>">Назад</a>
  </div>

  <div class="hr"></div>

  <h3 class="h2" style="margin-bottom:8px;">Где находится</h3>
  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Место</th>
          <th>Тип</th>
          <th>Кол-во</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($balances as $b): ?>
        <tr>
          <td><b><?= h($b['name']) ?></b></td>
          <td class="muted"><?= h($b['place_type']) ?></td>
          <td><?= h($b['qty']) ?></td>
        </tr>
        <?php endforeach; ?>
        <?php if (count($balances)===0): ?>
        <tr><td colspan="3" class="muted">Остатков нет</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="hr"></div>

  <h3 class="h2" style="margin-bottom:8px;">Последние движения (50)</h3>
  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>#</th>
          <th>Тип</th>
          <th>Откуда</th>
          <th>Куда</th>
          <th>Кол-во</th>
          <th>Причина</th>
          <th>Комментарий</th>
          <th>Кто</th>
          <th>Когда</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($moves as $m): ?>
        <tr>
          <td><?= (int)$m['id'] ?></td>
          <td><?= h($m['move_type']) ?></td>
          <td class="muted"><?= h($m['from_name']) ?></td>
          <td class="muted"><?= h($m['to_name']) ?></td>
          <td><b><?= h($m['qty']) ?></b></td>
          <td><?= h($m['reason']) ?></td>
          <td class="muted"><?= h($m['comment']) ?></td>
          <td class="muted"><?= h($m['user_name']) ?></td>
          <td class="muted"><?= h($m['created_at']) ?></td>
          <td style="white-space:nowrap;">
            <?php if (in_array($u['role'], ['admin','director','storekeeper','prod_head'], true)): ?>
              <a class="btn danger" href="index.php?m=warehouse&a=reverse&id=<?= (int)$m['id'] ?>&type=<?= h($type) ?>&item_id=<?= (int)$item['id'] ?>&location_id=<?= (int)$location_id ?>" onclick="return confirm('Отменить движение? Будет создана обратная запись.')">Отменить</a>
            <?php endif; ?>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (count($moves)===0): ?>
        <tr><td colspan="10" class="muted">Движений пока нет</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</section>
