<?php
// Печать бейджа 90x60 мм (горизонтально)
// QR кодирует номер сотрудника (emp_no или id)
$org = "Аэросмит";
$no = $code;
$qr_url = "https://api.qrserver.com/v1/create-qr-code/?size=140x140&data=" . urlencode($no);
?>
<!doctype html>
<html lang="ru">
<head>
  <meta charset="utf-8">
  <title>Бейдж — <?= h($e['full_name']) ?></title>
  <style>
    @page { size: 90mm 60mm; margin: 0; }
    body { margin:0; font-family: Arial, sans-serif; }
    .badge { width:90mm; height:60mm; box-sizing:border-box; padding:5mm; display:flex; gap:5mm; }
    .left { flex:1; display:flex; flex-direction:column; justify-content:space-between; }
    .org { font-size:14pt; font-weight:700; }
    .name { font-size:13pt; font-weight:700; }
    .meta { font-size:9pt; color:#333; }
    .photo { width:28mm; height:35mm; border:1px solid #ccc; border-radius:3mm; overflow:hidden; display:flex; align-items:center; justify-content:center; background:#f6f6f6; }
    .photo { background:#fff; }
    .photo img { width:100%; height:100%; object-fit:contain; }
    .right { width:35mm; display:flex; flex-direction:column; align-items:center; justify-content:space-between; }
    .qr img { width:35mm; height:35mm; }
    .no { font-size:10pt; font-weight:700; }
    .row { display:flex; gap:4mm; align-items:flex-start; }
  </style>
</head>
<body onload="window.print()">
  <div class="badge">
    <div class="left">
      <div>
        <div class="org"><?= h($org) ?></div>
        <div class="meta">Бейдж сотрудника</div>
      </div>

      <div class="row">
        <div class="photo">
          <?php if (!empty($e['photo_path'])): ?>
            <img src="<?= h($e['photo_path']) ?>" alt="Фото">
          <?php else: ?>
            <span class="meta">Фото</span>
          <?php endif; ?>
        </div>
        <div>
          <div class="name"><?= h($e['full_name']) ?></div>
          <div class="meta">№: <?= h($no) ?></div>
          <div class="meta"><?= h($e['location_name']) ?> / <?= h($e['workshop_name']) ?></div>
        </div>
      </div>

      <div class="meta">Дата печати: <?= date('d.m.Y') ?></div>
    </div>

    <div class="right">
      <div class="qr">
        <img src="<?= h($qr_url) ?>" alt="QR">
      </div>
      <div class="no"><?= h($no) ?></div>
    </div>
  </div>
</body>
</html>
