<?php require __DIR__ . '/_tabs.php'; ?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Настройки</span>
  <span class="crumb-sep">/</span>
  <span class="crumb">Маршруты передачи</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">Маршруты передачи готовых деталей</h2>
    <div class="muted">Локация + из цеха → в цех</div>
  </div>

  <form method="post" class="grid-4">
    <input type="hidden" name="do" value="create">

    <div class="field">
      <label>Локация</label>
      <select name="location_id" required>
        <option value="">Выберите</option>
        <?php foreach ($locations as $l): ?>
          <option value="<?= (int)$l['id'] ?>"><?= h($l['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>Из цеха</label>
      <select name="from_workshop_id" required>
        <option value="">Выберите</option>
        <?php foreach ($workshops as $w): ?>
          <option value="<?= (int)$w['id'] ?>"><?= h($w['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>В цех</label>
      <select name="to_workshop_id" required>
        <option value="">Выберите</option>
        <?php foreach ($workshops as $w): ?>
          <option value="<?= (int)$w['id'] ?>"><?= h($w['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="actions" style="align-self:end;">
      <button class="btn" type="submit">Добавить</button>
    </div>
  </form>

  <div class="hr"></div>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Локация</th>
          <th>Из цеха</th>
          <th>В цех</th>
          <th style="width:90px;"></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><?= h($r['location_name']) ?></td>
            <td><b><?= h($r['from_name']) ?></b></td>
            <td><b><?= h($r['to_name']) ?></b></td>
            <td>
              <a class="btn btn-danger btn-sm" href="index.php?m=settings&a=routes&del=<?= (int)$r['id'] ?>" onclick="return confirm('Удалить маршрут?')">Удалить</a>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (count($rows)===0): ?>
          <tr><td colspan="4" class="muted">Маршрутов пока нет</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</section>
