<?php $tab='ops'; require __DIR__ . '/_tabs.php'; ?>

<div class="card">
  <div class="card-head">
    <h2 class="h2">Настройки → Операции</h2>
    <div class="muted">списание материалов по выработке</div>
  </div>

  <form method="get" class="tabs" style="align-items:center;">
    <input type="hidden" name="m" value="settings">
    <input type="hidden" name="a" value="operations">

    <select name="location_id" onchange="this.form.submit()">
      <option value="0">Локация: все</option>
      <?php foreach ($locations as $l): ?>
        <option value="<?= (int)$l['id'] ?>" <?= ((int)$location_id===(int)$l['id']?'selected':'') ?>>
          <?= h($l['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>

    <select name="workshop_id">
      <option value="0">Цех: все</option>
      <?php foreach ($workshops as $w): ?>
        <option value="<?= (int)$w['id'] ?>" <?= ((int)$workshop_id===(int)$w['id']?'selected':'') ?>>
          <?= h($w['name']) ?>
        </option>
      <?php endforeach; ?>
    </select>

    <button class="btn" type="submit">Показать</button>
    <a class="btn primary" href="index.php?m=settings&a=operation_edit">+ Создать</a>
  </form>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Операция</th>
          <th>Локация</th>
          <th>Цех</th>
          <th>Цена</th>
          <th>План/день</th>
          <th>Статус</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($ops as $o): ?>
        <tr>
          <td><b><?= h($o['name']) ?></b></td>
          <td class="muted"><?= h($o['location_name']) ?></td>
          <td class="muted"><?= h($o['workshop_name']) ?></td>
          <td><?= h($o['price']) ?></td>
          <td><?= h($o['daily_plan_per_employee']) ?></td>
          <td><?= ((int)$o['is_active']===1) ? '<span class="pill" style="color:var(--ok);">активна</span>' : '<span class="pill" style="color:var(--danger);">выкл</span>' ?></td>
          <td style="white-space:nowrap;">
            <a class="btn" href="index.php?m=settings&a=operation_edit&id=<?= (int)$o['id'] ?>">Редактировать</a>
            <a class="btn danger" href="index.php?m=settings&a=operation_delete&id=<?= (int)$o['id'] ?>" onclick="return confirm('Удалить операцию?')">Удалить</a>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (count($ops)===0): ?>
        <tr><td colspan="7" class="muted">Операций пока нет</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="small" style="margin-top:10px;">
    Материалы/расходники на операцию задаются в карточке операции. При вводе выработки система списывает их со склада цеха.
  </div>
</div>
