<?php $tab='operations'; require __DIR__ . '/_tabs.php'; ?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">План/факт</span>
  <span class="crumb-sep">/</span>
  <span class="crumb">Операции</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">План/факт по операциям</h2>
    <div class="muted">План (MVP) = дневной план операции × дни периода × (кол-во сотрудников цеха). Факт — из выработки.</div>
  </div>

  <form method="get" class="tabs" style="align-items:end;">
    <input type="hidden" name="m" value="planfact">
    <input type="hidden" name="a" value="operations">

    <div class="field">
      <label>Период: с</label>
      <input type="date" name="from" value="<?= h($from) ?>">
    </div>
    <div class="field">
      <label>по</label>
      <input type="date" name="to" value="<?= h($to) ?>">
    </div>

    <div class="field">
      <label>Локация</label>
      <select name="location_id">
        <option value="0">Все</option>
        <?php foreach ($locations as $l): ?>
          <option value="<?= (int)$l['id'] ?>" <?= ((int)$location_id===(int)$l['id']?'selected':'') ?>><?= h($l['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>Цех</label>
      <select name="workshop_id">
        <option value="0">Все</option>
        <?php foreach ($workshops as $w): ?>
          <option value="<?= (int)$w['id'] ?>" <?= ((int)$workshop_id===(int)$w['id']?'selected':'') ?>><?= h($w['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>Сотрудник</label>
      <select name="employee_id">
        <option value="0">Все</option>
        <?php foreach ($employees as $e): ?>
          <option value="<?= (int)$e['id'] ?>" <?= ((int)$employee_id===(int)$e['id']?'selected':'') ?>><?= h($e['full_name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>Операция</label>
      <select name="operation_id">
        <option value="0">Все</option>
        <?php foreach ($operations as $o): ?>
          <option value="<?= (int)$o['id'] ?>" <?= ((int)$operation_id===(int)$o['id']?'selected':'') ?>><?= h($o['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="actions">
      <button class="btn" type="submit">Показать</button>
      <a class="btn" href="index.php?m=planfact&a=operations&from=<?= h(urlencode($from)) ?>&to=<?= h(urlencode($to)) ?>&location_id=<?= (int)$location_id ?>&workshop_id=<?= (int)$workshop_id ?>&employee_id=<?= (int)$employee_id ?>&operation_id=<?= (int)$operation_id ?>&export=1">Экспорт .xlsx</a>
    </div>
  </form>

  <div class="table-wrap" style="margin-top:12px;">
    <table>
      <thead>
        <tr>
          <th>Операция</th>
          <th>Сотрудник</th>
          <th>Локация</th>
          <th>Цех</th>
          <th>План</th>
          <th>Факт</th>
          <th>% выполнения</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><b><?= h($r['op_name']) ?></b></td>
            <td><?= h($r['emp_name']) ?></td>
            <td><?= h($r['location_name']) ?></td>
            <td><?= h($r['workshop_name']) ?></td>
            <td><?= h($r['plan']) ?></td>
            <td><?= h($r['fact']) ?></td>
            <td><?= h($r['pct']) ?>%</td>
          </tr>
        <?php endforeach; ?>
        <?php if (count($rows)===0): ?>
          <tr><td colspan="7" class="muted">Нет данных</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="small" style="margin-top:10px;">
    Дней в периоде: <b><?= (int)$days ?></b>
  </div>
</section>
