<script src="assets/parts.js?v=1" defer></script>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <a class="crumb" href="index.php?m=parts&a=index">Детали</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Карточка детали</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">Карточка детали</h2>
    <div class="muted"><?= $id>0 ? 'редактирование' : 'создание' ?></div>
  </div>

  <?php if (!empty($msg)): ?><div class="alert"><?= h($msg) ?></div><?php endif; ?>

  <form method="post">
    <div class="form-grid">
      <div class="field">
        <label>Локация*</label>
        <select name="location_id" required onchange="this.form.submit()">
          <option value="0">— выберите —</option>
          <?php foreach ($locations as $l): ?>
            <option value="<?= (int)$l['location_id'] ?>" <?= ((int)$selected_location_id===(int)$l['location_id']?'selected':'') ?>>
              <?= h($l['location_name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
        <div class="small">Цех выбирается внутри локации.</div>
      </div>

      <div class="field">
        <label>Цех производства*</label>
        <select name="workshop_id" required>
          <option value="0">— выберите —</option>
          <?php foreach ($workshops as $w): ?>
            <option value="<?= (int)$w['id'] ?>" <?= ((int)($item['workshop_id'] ?? 0)===(int)$w['id']?'selected':'') ?>>
              <?= h($w['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>

    <div class="form-grid" style="margin-top:12px;">
      <div class="field">
        <label>Название детали*</label>
        <input name="name" required value="<?= h($item['name'] ?? '') ?>">
      </div>
      <div class="field">
        <label>Код (не обязательно)</label>
        <input name="code" value="<?= h($item['code'] ?? '') ?>">
      </div>
    </div>

    <div class="form-grid" style="margin-top:12px;">
      <div class="field">
        <label>Дневной план на отдел (по детали)</label>
        <input name="daily_plan" value="<?= h($item['daily_plan'] ?? '0') ?>" placeholder="например: 50">
      </div>
      <div class="field">
        <label>Кол-во детали на изделие (по умолчанию)</label>
        <input name="qty_per_product_default" value="<?= h($item['qty_per_product_default'] ?? '1') ?>" placeholder="например: 2">
        <div class="small">В модуле “Готовая продукция” можно будет задать по каждому изделию отдельно.</div>
      </div>
    </div>

    <div class="field" style="margin-top:12px;">
      <label><input type="checkbox" name="is_active" value="1" <?= ((int)($item['is_active'] ?? 1)===1?'checked':'') ?>> Активна</label>
    </div>

    <div class="field" style="margin-top:12px;">
      <label>Описание</label>
      <textarea name="description"><?= h($item['description'] ?? '') ?></textarea>
    </div>

    <div class="hr"></div>

    <section class="card soft">
      <div class="card-head">
        <h2 class="h2">Материалы на 1 деталь</h2>
        <div class="muted">спецификация</div>
      </div>

      <div class="actions">
        <button class="btn" type="button" onclick="partsAddMatRow()">+ Добавить материал</button>
      </div>

      <div class="table-wrap">
        <table>
          <thead>
            <tr>
              <th>Материал</th>
              <th>Кол-во на 1 деталь</th>
              <th></th>
            </tr>
          </thead>
          <tbody id="pm-body">
            <?php foreach ($pm as $r): ?>
            <tr>
              <td>
                <select name="pm_material_id[]">
                  <?php foreach ($materials as $m): ?>
                    <option value="<?= (int)$m['id'] ?>" <?= ((int)$r['material_id']===(int)$m['id']?'selected':'') ?>><?= h($m['name']) ?></option>
                  <?php endforeach; ?>
                </select>
              </td>
              <td><input name="pm_qty[]" value="<?= h($r['qty_per_part']) ?>" style="max-width:220px;"></td>
              <td><button class="btn danger" type="button" onclick="partsDelRow(this)">Удалить</button></td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <template id="pm-template">
        <tr>
          <td>
            <select name="pm_material_id[]">
              <?php foreach ($materials as $m): ?>
                <option value="<?= (int)$m['id'] ?>"><?= h($m['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </td>
          <td><input name="pm_qty[]" value="1" style="max-width:220px;"></td>
          <td><button class="btn danger" type="button" onclick="partsDelRow(this)">Удалить</button></td>
        </tr>
      </template>
    </section>

    <div class="hr"></div>

    <section class="card soft">
      <div class="card-head">
        <h2 class="h2">Операции на 1 деталь</h2>
        <div class="muted">технологический маршрут (без последовательности)</div>
      </div>

      <div class="actions">
        <button class="btn" type="button" onclick="partsAddOpRow()">+ Добавить операцию</button>
      </div>

      <div class="table-wrap">
        <table>
          <thead>
            <tr>
              <th>Операция</th>
              <th>Кол-во на 1 деталь</th>
              <th></th>
            </tr>
          </thead>
          <tbody id="po-body">
            <?php foreach ($po as $r): ?>
            <tr>
              <td>
                <select name="po_operation_id[]">
                  <?php foreach ($ops as $o): ?>
                    <option value="<?= (int)$o['id'] ?>" <?= ((int)$r['operation_id']===(int)$o['id']?'selected':'') ?>>
                      <?= h($o['location_name'].' / '.$o['workshop_name'].' / '.$o['name']) ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </td>
              <td><input name="po_qty[]" value="<?= h($r['qty_per_part']) ?>" style="max-width:220px;"></td>
              <td><button class="btn danger" type="button" onclick="partsDelRow(this)">Удалить</button></td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <template id="po-template">
        <tr>
          <td>
            <select name="po_operation_id[]">
              <?php foreach ($ops as $o): ?>
                <option value="<?= (int)$o['id'] ?>"><?= h($o['location_name'].' / '.$o['workshop_name'].' / '.$o['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </td>
          <td><input name="po_qty[]" value="1" style="max-width:220px;"></td>
          <td><button class="btn danger" type="button" onclick="partsDelRow(this)">Удалить</button></td>
        </tr>
      </template>

      <div class="small" style="margin-top:10px;">
        Тут задаём “какие операции нужны для изготовления детали”. Последовательность не задаётся.
      </div>
    </section>

    <div class="actions" style="margin-top:14px;">
      <button class="btn primary" type="submit">Сохранить</button>
      <a class="btn" href="index.php?m=parts&a=index">Назад</a>
    </div>
  </form>
</section>
