<?php $tab='adjustments'; require __DIR__ . '/_tabs.php'; ?>

<div class="crumbs">
  <a class="crumb" href="index.php">Главная</a>
  <span class="crumb-sep">/</span>
  <span class="crumb">Финансы</span>
  <span class="crumb-sep">/</span>
  <span class="crumb">Премии/штрафы</span>
</div>

<section class="card">
  <div class="card-head">
    <h2 class="h2">Премии и штрафы</h2>
    <div class="muted">Записи учитываются в ФОТ. Удаление — только через “удалить” с причиной.</div>
  </div>

  <?php if (!empty($ok)): ?>
    <div class="alert" style="border-color: rgba(25,195,125,.35);">Готово.</div>
  <?php endif; ?>
  <?php if (!empty($msg)): ?><div class="alert"><?= h($msg) ?></div><?php endif; ?>

  <form method="get" class="tabs" style="align-items:end;">
    <input type="hidden" name="m" value="finance">
    <input type="hidden" name="a" value="adjustments">

    <div class="field">
      <label>Период: с</label>
      <input type="date" name="from" value="<?= h($from) ?>">
    </div>
    <div class="field">
      <label>по</label>
      <input type="date" name="to" value="<?= h($to) ?>">
    </div>

    <div class="field">
      <label>Локация</label>
      <select name="location_id">
        <option value="0">Все</option>
        <?php foreach ($locations as $l): ?>
          <option value="<?= (int)$l['id'] ?>" <?= ((int)$location_id===(int)$l['id']?'selected':'') ?>><?= h($l['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>Цех</label>
      <select name="workshop_id">
        <option value="0">Все</option>
        <?php foreach ($workshops as $w): ?>
          <option value="<?= (int)$w['id'] ?>" <?= ((int)$workshop_id===(int)$w['id']?'selected':'') ?>><?= h($w['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>Сотрудник</label>
      <select name="employee_id">
        <option value="0">Все</option>
        <?php foreach ($employees as $e): ?>
          <option value="<?= (int)$e['id'] ?>" <?= ((int)$employee_id===(int)$e['id']?'selected':'') ?>><?= h($e['full_name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="actions">
      <button class="btn" type="submit">Показать</button>
    </div>
  </form>

  <div class="hr"></div>

  <div class="card-head">
    <h2 class="h2">Добавить запись</h2>
    <div class="muted">Сумма > 0. Штраф вычитается автоматически.</div>
  </div>

  <form method="post">
    <div class="form-grid">
      <div class="field">
        <label>Дата*</label>
        <input type="date" name="adj_date" value="<?= h(date('Y-m-d')) ?>" required>
      </div>

      <div class="field">
        <label>Сотрудник*</label>
        <select name="employee_id" required>
          <option value="0">— выберите —</option>
          <?php foreach ($employees as $e): ?>
            <option value="<?= (int)$e['id'] ?>"><?= h($e['full_name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="field">
        <label>Тип*</label>
        <select name="adj_type" required>
          <option value="bonus">Премия</option>
          <option value="penalty">Штраф</option>
        </select>
      </div>

      <div class="field">
        <label>Сумма, ₽*</label>
        <input name="amount" value="" placeholder="например: 1500" required>
      </div>

      <div class="field">
        <label>Причина</label>
        <input name="reason" value="" placeholder="">
      </div>

      <div class="field">
        <label>Комментарий</label>
        <input name="comment" value="" placeholder="">
      </div>
    </div>

    <div class="actions" style="margin-top:12px;">
      <button class="btn primary" type="submit">Добавить</button>
    </div>
  </form>

  <div class="hr"></div>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>Дата</th>
          <th>Локация</th>
          <th>Цех</th>
          <th>Сотрудник</th>
          <th>Тип</th>
          <th>Сумма, ₽</th>
          <th>Причина</th>
          <th>Кто</th>
          <th style="width:220px;"></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><?= h($r['adj_date']) ?></td>
            <td><?= h($r['location_name']) ?></td>
            <td><?= h($r['workshop_name']) ?></td>
            <td><b><?= h($r['full_name']) ?></b></td>
            <td><?= h($r['adj_type']) ?></td>
            <td><?= h($r['amount']) ?></td>
            <td class="muted"><?= h($r['reason']) ?></td>
            <td class="muted"><?= h($r['user_name'] ?? '') ?></td>
            <td>
              <form method="post" action="index.php?m=finance&a=adjustment_delete" style="display:flex; gap:8px;">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <input name="reason" placeholder="Причина удаления" required>
                <button class="btn sm danger" type="submit" onclick="return confirm('Удалить запись?');">Удалить</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (count($rows)===0): ?>
          <tr><td colspan="9" class="muted">Нет данных</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</section>
