<?php
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
require_once dirname(__DIR__, 2) . '/app/audit.php';
require_once dirname(__DIR__, 2) . '/app/warehouse.php';

function staff_flash_set($key, $val) {
    if (session_status() !== PHP_SESSION_ACTIVE) @session_start();
    $_SESSION[$key] = $val;
}
function staff_flash_get($key) {
    if (session_status() !== PHP_SESSION_ACTIVE) @session_start();
    if (!isset($_SESSION[$key])) return null;
    $v = $_SESSION[$key];
    unset($_SESSION[$key]);
    return $v;
}
function staff_upload_err_text($code) {
    $map = [
        UPLOAD_ERR_INI_SIZE => 'Файл слишком большой (лимит upload_max_filesize).',
        UPLOAD_ERR_FORM_SIZE => 'Файл слишком большой (лимит формы).',
        UPLOAD_ERR_PARTIAL => 'Файл загружен частично. Повторите.',
        UPLOAD_ERR_NO_FILE => 'Файл не выбран.',
        UPLOAD_ERR_NO_TMP_DIR => 'Нет временной папки для загрузки (upload_tmp_dir).',
        UPLOAD_ERR_CANT_WRITE => 'Не могу записать файл на диск (права).',
        UPLOAD_ERR_EXTENSION => 'Загрузка остановлена расширением PHP.',
    ];
    return $map[$code] ?? ('Ошибка загрузки (код '.$code.').');
}

function staff_index() {
    $u = require_role(['admin','director','prod_head','brigadier']);

    $location_id = (int)($_GET['location_id'] ?? 0);
    $workshop_id = (int)($_GET['workshop_id'] ?? 0);
    $q = trim($_GET['q'] ?? '');

    $locations = db_fetch_all(db_query("SELECT id, name FROM locations ORDER BY name"));
    if ($location_id<=0 && !empty($u['location_id'])) $location_id = (int)$u['location_id'];

    $workshops = ($location_id>0)
      ? db_fetch_all(db_query("SELECT id, name FROM workshops WHERE location_id=$location_id ORDER BY name"))
      : db_fetch_all(db_query("SELECT id, name FROM workshops ORDER BY name"));

    $where = "e.is_active=1";
    if ($location_id>0) $where .= " AND e.location_id=$location_id";
    if ($workshop_id>0) $where .= " AND e.workshop_id=$workshop_id";
    if ($q!=='') {
        $qesc = db_escape($q);
        $where .= " AND (e.full_name LIKE '%$qesc%' OR e.emp_no LIKE '%$qesc%')";
    }

    $rows = db_fetch_all(db_query("
        SELECT e.*, l.name AS location_name, w.name AS workshop_name
        FROM employees e
        JOIN locations l ON l.id=e.location_id
        JOIN workshops w ON w.id=e.workshop_id
        WHERE $where
        ORDER BY e.full_name
        LIMIT 500
    "));

    render('staff/list', [
        'u'=>$u,
        'rows'=>$rows,
        'locations'=>$locations,
        'workshops'=>$workshops,
        'location_id'=>$location_id,
        'workshop_id'=>$workshop_id,
        'q'=>$q
    ]);
}

function staff_edit() {
    $u = require_role(['admin','director','prod_head','brigadier']);

    $id = (int)($_GET['id'] ?? 0);
    $item = null;
    if ($id>0) {
        $item = db_fetch_one(db_query("SELECT * FROM employees WHERE id=$id LIMIT 1"));
        if (!$item) { http_response_code(404); echo "Сотрудник не найден"; exit; }
    }

    $locations = db_fetch_all(db_query("SELECT id, name FROM locations ORDER BY name"));
    $workshops = db_fetch_all(db_query("SELECT id, name, location_id FROM workshops ORDER BY name"));

    $msg = '';
    $flash = staff_flash_get('staff_msg');
    if (!empty($flash)) $msg = $flash;

    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $emp_no = trim($_POST['emp_no'] ?? '');
        $full_name = trim($_POST['full_name'] ?? '');
        $phone = trim($_POST['phone'] ?? '');
        $birth_date = trim($_POST['birth_date'] ?? '');
        $hired_date = trim($_POST['hired_date'] ?? '');
        $location_id = (int)($_POST['location_id'] ?? 0);
        $workshop_id = (int)($_POST['workshop_id'] ?? 0);
        $is_active = (int)($_POST['is_active'] ?? 1);

        // Оплата бригадира (админ/директор могут заполнять)
        $brig_base = str_replace(',', '.', trim($_POST['brigadier_base_salary'] ?? '0'));
        $brig_pct  = str_replace(',', '.', trim($_POST['brigadier_percent'] ?? '0'));
        if (!is_numeric($brig_base)) $brig_base = 0;
        if (!is_numeric($brig_pct)) $brig_pct = 0;
        $brig_base = (float)$brig_base;
        $brig_pct  = (float)$brig_pct;
        if ($brig_base < 0) $brig_base = 0;
        if ($brig_pct  < 0) $brig_pct  = 0;

// Удаление фото (кнопка рядом с фото). ВАЖНО: не используем отдельную форму (чтобы не было вложенных form)
if ($id > 0 && isset($_POST['photo_delete']) && (int)($_POST['photo_delete'] ?? 0) === 1) {
    $e = db_fetch_one(db_query("SELECT photo_path FROM employees WHERE id=$id LIMIT 1"));
    $path = trim((string)($e['photo_path'] ?? ''));
    if ($path !== '') {
        if (!(strpos($path, 'http://')===0 || strpos($path, 'https://')===0)) {
            $abs = dirname(__DIR__, 2) . '/' . ltrim($path, '/');
            if (is_file($abs)) @unlink($abs);
        }
    }
    db_query("UPDATE employees SET photo_path='' WHERE id=$id");
    audit('UPDATE','employees',$id,(int)$u['id'], ['event'=>'Фото сотрудника удалено','photo_deleted'=>1]);
    staff_flash_set('staff_msg', 'Фото удалено.');
    header("Location: index.php?m=staff&a=edit&id=$id&ok=1");
    exit;
}

        if ($full_name==='') $msg = 'ФИО обязательно';
        else if ($location_id<=0 || $workshop_id<=0) $msg = 'Выберите локацию и цех';
        else {
            $emp_no_esc = db_escape($emp_no);
            $full_esc = db_escape($full_name);
            $phone_esc = db_escape($phone);

            $bd_sql = ($birth_date!=='' ? "'" . db_escape($birth_date) . "'" : "NULL");
            $hd_sql = ($hired_date!=='' ? "'" . db_escape($hired_date) . "'" : "NULL");

            // ТЕКУЩИЙ путь фото (если редактирование)
            $photo_path = $item ? (string)($item['photo_path'] ?? '') : '';
            $photo_path = staff_handle_photo_upload($photo_path, $id>0 ? $id : 0);

            $photo_esc = db_escape($photo_path);

            if ($id>0) {
                db_query("UPDATE employees SET emp_no='$emp_no_esc', full_name='$full_esc', phone='$phone_esc',
                          birth_date=$bd_sql, hired_date=$hd_sql, photo_path='$photo_esc',
                          brigadier_base_salary=$brig_base, brigadier_percent=$brig_pct,
                          location_id=$location_id, workshop_id=$workshop_id, is_active=$is_active
                          WHERE id=$id");
                audit('UPDATE','employees',$id,(int)$u['id'],'Сотрудник обновлён: '.$full_name);
            } else {
                db_query("INSERT INTO employees(emp_no,full_name,phone,birth_date,hired_date,photo_path,brigadier_base_salary,brigadier_percent,location_id,workshop_id,is_active,created_at,created_by)
                          VALUES ('$emp_no_esc','$full_esc','$phone_esc',$bd_sql,$hd_sql,'$photo_esc',$brig_base,$brig_pct,$location_id,$workshop_id,$is_active,NOW(),".(int)$u['id'].")");
                $id = (int)db_last_id();
                audit('CREATE','employees',$id,(int)$u['id'], ['full_name'=>$full_name,'location_id'=>$location_id,'workshop_id'=>$workshop_id]);
                // создаём место хранения сотрудника
                staff_employee_place_id($id, $location_id);
            }

            header("Location: index.php?m=staff&a=edit&id=$id&ok=1");
            exit;
        }
    }

    if ($id>0) {
        // обновим item после сохранений/переходов
        $item = db_fetch_one(db_query("SELECT * FROM employees WHERE id=$id LIMIT 1"));
    } else {
        $item = ['id'=>0,'emp_no'=>'','full_name'=>'','phone'=>'','birth_date'=>'','hired_date'=>'','photo_path'=>'','location_id'=>0,'workshop_id'=>0,'is_active'=>1];
    }

    render('staff/edit', [
        'u'=>$u,
        'item'=>$item,
        'locations'=>$locations,
        'workshops'=>$workshops,
        'msg'=>$msg,
        'ok'=>($_GET['ok'] ?? ''),
        'err'=>($_GET['err'] ?? '')
    ]);
}

function staff_handle_photo_upload($current_path, $employee_id) {
    if (!isset($_FILES['photo'])) return $current_path;

    $err = (int)($_FILES['photo']['error'] ?? UPLOAD_ERR_NO_FILE);
    if ($err === UPLOAD_ERR_NO_FILE) return $current_path;
    if ($err !== UPLOAD_ERR_OK) {
        staff_flash_set('staff_msg', 'Фото не загружено: ' . staff_upload_err_text($err));
        return $current_path;
    }

    if (empty($_FILES['photo']['tmp_name']) || !is_uploaded_file($_FILES['photo']['tmp_name'])) {
        staff_flash_set('staff_msg', 'Фото не загружено: временный файл недоступен.');
        return $current_path;
    }

    $name = (string)($_FILES['photo']['name'] ?? '');
    $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
    if (!in_array($ext, ['jpg','jpeg','png','webp'], true)) {
        staff_flash_set('staff_msg', 'Фото не загружено: допустимы только JPG/PNG/WEBP.');
        return $current_path;
    }

    $root = dirname(__DIR__, 2);
    $dir = $root . '/uploads/employees';
    if (!is_dir($dir) && !@mkdir($dir, 0775, true)) {
        staff_flash_set('staff_msg', 'Фото не загружено: не удалось создать папку uploads/employees.');
        return $current_path;
    }

    $safe_id = ($employee_id>0) ? $employee_id : 'new';
    $fname = 'emp_'.$safe_id.'_'.date('Ymd_His').'_'.mt_rand(1000,9999).'.'.$ext;
    $dest = $dir . '/' . $fname;

    if (@move_uploaded_file($_FILES['photo']['tmp_name'], $dest)) {
        @chmod($dest, 0664);
        return 'uploads/employees/'.$fname;
    }

    staff_flash_set('staff_msg', 'Фото не загружено: move_uploaded_file не сработал. Проверьте права и upload_tmp_dir.');
    return $current_path;
}

function staff_employee_place_id($employee_id, $location_id) {
    $employee_id = (int)$employee_id;
    $location_id = (int)$location_id;
    $p = db_fetch_one(db_query("SELECT id FROM storage_places WHERE place_type='employee' AND employee_id=$employee_id AND location_id=$location_id LIMIT 1"));
    if ($p) return (int)$p['id'];

    $e = db_fetch_one(db_query("SELECT full_name FROM employees WHERE id=$employee_id LIMIT 1"));
    $name = $e ? ('Сотрудник: '.$e['full_name']) : ('Сотрудник #'.$employee_id);

    db_query("INSERT INTO storage_places(location_id,place_type,employee_id,name,is_active,created_at)
              VALUES ($location_id,'employee',$employee_id,'".db_escape($name)."',1,NOW())");
    return (int)db_last_id();
}

function staff_employee_tools($employee_id, $location_id) {
    $employee_id = (int)$employee_id;
    $location_id = (int)$location_id;
    $pid = staff_employee_place_id($employee_id, $location_id);

    $rows = db_fetch_all(db_query("
      SELECT t.id AS tool_id, t.name,
        COALESCE(SUM(x.delta),0) AS qty
      FROM tools t
      LEFT JOIN (
        SELECT sm.item_id, sm.qty AS delta
        FROM stock_moves sm
        WHERE sm.item_type='tool' AND sm.to_place_id=$pid AND sm.is_reversed=0
        UNION ALL
        SELECT sm.item_id, -sm.qty AS delta
        FROM stock_moves sm
        WHERE sm.item_type='tool' AND sm.from_place_id=$pid AND sm.is_reversed=0
      ) x ON x.item_id=t.id
      GROUP BY t.id
      HAVING qty > 0
      ORDER BY t.name
    "));
    return $rows;
}


function staff_photo_delete() {
    $u = require_role(['admin','director','prod_head','brigadier']);
    if ($_SERVER['REQUEST_METHOD']!=='POST') { http_response_code(405); exit; }

    $id = (int)($_POST['id'] ?? 0);
    if ($id<=0) { header("Location: index.php?m=staff&a=index"); exit; }

    $e = db_fetch_one(db_query("SELECT photo_path FROM employees WHERE id=$id LIMIT 1"));
    if (!$e) { header("Location: index.php?m=staff&a=index"); exit; }

    $path = trim((string)($e['photo_path'] ?? ''));
    if ($path !== '') {
        // удаляем файл только если это локальный путь внутри проекта
        if (strpos($path, 'http://')===0 || strpos($path, 'https://')===0) {
            // внешний URL — просто очищаем
        } else {
            $rel = ltrim($path, '/');
            // защита от ../
            if (strpos($rel, '..')===false) {
                $abs = dirname(__DIR__, 2) . '/' . $rel;
                if (is_file($abs)) @unlink($abs);
            }
        }
    }

    db_query("UPDATE employees SET photo_path='' WHERE id=$id");
    audit('UPDATE','employees',$id,(int)$u['id'], ['photo_deleted'=>1]);

    staff_flash_set('staff_msg', 'Фото удалено.');
    header("Location: index.php?m=staff&a=edit&id=$id&ok=1");
    exit;
}

function staff_tool_action() {
    $u = require_role(['admin','director','prod_head','brigadier']);
    if ($_SERVER['REQUEST_METHOD']!=='POST') { http_response_code(405); exit; }

    $employee_id = (int)($_POST['employee_id'] ?? 0);
    $tool_id = (int)($_POST['tool_id'] ?? 0);
    $action = trim($_POST['action'] ?? 'issue'); // issue/return/writeoff
    $qty = str_replace(',', '.', trim($_POST['qty'] ?? '1'));
    $reason = trim($_POST['reason'] ?? '');
    $comment = trim($_POST['comment'] ?? '');

    if ($employee_id<=0 || $tool_id<=0) { header("Location: index.php?m=staff&a=index"); exit; }
    if (!is_numeric($qty)) { header("Location: index.php?m=staff&a=edit&id=$employee_id&err=qty"); exit; }
    $qty = (float)$qty;
    if ($qty<=0) { header("Location: index.php?m=staff&a=edit&id=$employee_id&err=qty"); exit; }

    $e = db_fetch_one(db_query("SELECT * FROM employees WHERE id=$employee_id LIMIT 1"));
    if (!$e) { header("Location: index.php?m=staff&a=index"); exit; }

    $location_id = (int)$e['location_id'];
    $workshop_id = (int)$e['workshop_id'];

    $emp_place = staff_employee_place_id($employee_id, $location_id);

    $wh = db_fetch_one(db_query("SELECT id FROM storage_places WHERE place_type='warehouse' AND location_id=$location_id LIMIT 1"));
    $wh_place = $wh ? (int)$wh['id'] : 0;

    if ($action==='issue') {
        if ($wh_place<=0) { header("Location: index.php?m=staff&a=edit&id=$employee_id&err=warehouse"); exit; }
        $bal = wh_get_balance('tool',$tool_id,$wh_place);
        if ($bal < $qty) { header("Location: index.php?m=staff&a=edit&id=$employee_id&err=nobal"); exit; }

        wh_move_create([
            'item_type'=>'tool',
            'item_id'=>$tool_id,
            'move_type'=>'transfer',
            'from_place_id'=>$wh_place,
            'to_place_id'=>$emp_place,
            'qty'=>$qty,
            'reason'=>($reason!==''?$reason:'Выдача сотруднику'),
            'comment'=>$comment,
            'created_by'=>(int)$u['id'],
        ]);

        db_query("INSERT INTO employee_tool_events(event_type,employee_id,tool_id,qty,location_id,workshop_id,reason,comment,created_at,created_by)
                  VALUES ('issue',$employee_id,$tool_id,$qty,$location_id,$workshop_id,'".db_escape($reason)."','".db_escape($comment)."',NOW(),".(int)$u['id'].")");
    } elseif ($action==='return') {
        if ($wh_place<=0) { header("Location: index.php?m=staff&a=edit&id=$employee_id&err=warehouse"); exit; }
        $bal = wh_get_balance('tool',$tool_id,$emp_place);
        if ($bal < $qty) { header("Location: index.php?m=staff&a=edit&id=$employee_id&err=nobal_emp"); exit; }

        wh_move_create([
            'item_type'=>'tool',
            'item_id'=>$tool_id,
            'move_type'=>'transfer',
            'from_place_id'=>$emp_place,
            'to_place_id'=>$wh_place,
            'qty'=>$qty,
            'reason'=>($reason!==''?$reason:'Возврат на склад'),
            'comment'=>$comment,
            'created_by'=>(int)$u['id'],
        ]);

        db_query("INSERT INTO employee_tool_events(event_type,employee_id,tool_id,qty,location_id,workshop_id,reason,comment,created_at,created_by)
                  VALUES ('return',$employee_id,$tool_id,$qty,$location_id,$workshop_id,'".db_escape($reason)."','".db_escape($comment)."',NOW(),".(int)$u['id'].")");
    } else { // writeoff
        $bal = wh_get_balance('tool',$tool_id,$emp_place);
        if ($bal < $qty) { header("Location: index.php?m=staff&a=edit&id=$employee_id&err=nobal_emp"); exit; }
        if ($reason==='') { header("Location: index.php?m=staff&a=edit&id=$employee_id&err=reason"); exit; }

        wh_move_create([
            'item_type'=>'tool',
            'item_id'=>$tool_id,
            'move_type'=>'writeoff',
            'from_place_id'=>$emp_place,
            'to_place_id'=>null,
            'qty'=>$qty,
            'reason'=>$reason,
            'comment'=>$comment,
            'created_by'=>(int)$u['id'],
        ]);

        db_query("INSERT INTO employee_tool_events(event_type,employee_id,tool_id,qty,location_id,workshop_id,reason,comment,created_at,created_by)
                  VALUES ('writeoff',$employee_id,$tool_id,$qty,$location_id,$workshop_id,'".db_escape($reason)."','".db_escape($comment)."',NOW(),".(int)$u['id'].")");
    }

    header("Location: index.php?m=staff&a=edit&id=$employee_id&ok=1");
    exit;
}

function staff_badge() {
    $u = require_role(['admin','director','prod_head','brigadier']);
    $id = (int)($_GET['id'] ?? 0);
    $e = db_fetch_one(db_query("SELECT e.*, l.name AS location_name, w.name AS workshop_name
                               FROM employees e
                               JOIN locations l ON l.id=e.location_id
                               JOIN workshops w ON w.id=e.workshop_id
                               WHERE e.id=$id LIMIT 1"));
    if (!$e) { http_response_code(404); echo "Работник не найден"; exit; }

    $code = trim($e['emp_no']);
    if ($code==='') $code = (string)$e['id'];

    header('Content-Type: text/html; charset=utf-8');
    $view = dirname(__DIR__, 2) . '/views/staff/badge.php';
    include $view;
    exit;
}
