<?php
// modules/settings/products.php — раздел "Готовая продукция" (Настройки)
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
require_once dirname(__DIR__, 2) . '/app/audit.php';

function settings_products() {
    $u = require_role(['admin','director']);

    $q = trim($_GET['q'] ?? '');
    $where = "1=1";
    if ($q!=='') {
        $qesc = db_escape($q);
        $where .= " AND p.name LIKE '%$qesc%'";
    }

    $rows = db_fetch_all(db_query("
      SELECT p.*,
             (SELECT COUNT(*) FROM product_parts pp WHERE pp.product_id=p.id) AS parts_cnt
      FROM products p
      WHERE $where
      ORDER BY p.name
    "));

    render('settings/products_list', ['u'=>$u,'q'=>$q,'rows'=>$rows]);
}

function settings_product_edit() {
    $u = require_role(['admin','director']);
    $id = (int)($_GET['id'] ?? 0);

    $item = null;
    $pp = [];
    if ($id>0) {
        $item = db_fetch_one(db_query("SELECT * FROM products WHERE id=$id LIMIT 1"));
        if (!$item) { http_response_code(404); echo "Изделие не найдено"; exit; }

        $pp = db_fetch_all(db_query("
          SELECT pp.*, prt.name AS part_name
          FROM product_parts pp
          JOIN parts prt ON prt.id=pp.part_id
          WHERE pp.product_id=$id
          ORDER BY pp.id
        "));
    }

    $parts = db_fetch_all(db_query("SELECT id, name FROM parts WHERE is_active=1 ORDER BY name"));

    $msg = '';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $name = trim($_POST['name'] ?? '');
        $desc = trim($_POST['description'] ?? '');
        $is_active = isset($_POST['is_active']) ? 1 : 0;

        $pp_part = $_POST['pp_part_id'] ?? [];
        $pp_qty  = $_POST['pp_qty'] ?? [];

        if ($name==='') $msg='Наименование изделия обязательно';
        else {
            $name_esc = db_escape($name);
            $desc_esc = db_escape($desc);

            if ($id>0) {
                db_query("UPDATE products SET name='$name_esc', description='$desc_esc', is_active=$is_active WHERE id=$id");
                audit('UPDATE','products',$id,(int)$u['id'], ['name'=>$name]);
                db_query("DELETE FROM product_parts WHERE product_id=$id");
            } else {
                db_query("INSERT INTO products(name,description,is_active,created_at) VALUES ('$name_esc','$desc_esc',$is_active,NOW())");
                $id = (int)db_last_id();
                audit('CREATE','products',$id,(int)$u['id'], ['name'=>$name]);
            }

            // состав изделия
            $used = [];
            for ($i=0; $i<count($pp_part); $i++) {
                $pid = (int)($pp_part[$i] ?? 0);
                $q = str_replace(',', '.', trim($pp_qty[$i] ?? '1'));
                if ($pid<=0) continue;
                if (!is_numeric($q) || (float)$q<=0) continue;

                // не даём дублировать одну и ту же деталь
                if (isset($used[$pid])) continue;
                $used[$pid] = 1;

                db_query("INSERT INTO product_parts(product_id,part_id,qty_per_product) VALUES ($id,$pid,".(float)$q.")");
            }

            header('Location: index.php?m=settings&a=products');
            exit;
        }

        $item = ['id'=>$id,'name'=>$name,'description'=>$desc,'is_active'=>$is_active];
    }

    render('settings/product_edit', [
        'u'=>$u,
        'id'=>$id,
        'item'=>$item,
        'msg'=>$msg,
        'parts'=>$parts,
        'pp'=>$pp
    ]);
}

function settings_product_delete() {
    $u = require_role(['admin','director']);
    $id = (int)($_GET['id'] ?? 0);
    if ($id<=0) { header('Location: index.php?m=settings&a=products'); exit; }

    db_query("DELETE FROM products WHERE id=$id"); // каскадом удалит состав
    audit('DELETE','products',$id,(int)$u['id'], null);

    header('Location: index.php?m=settings&a=products');
    exit;
}
