<?php
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
require_once dirname(__DIR__, 2) . '/app/audit.php';

function quality_index() {
    // ОТК имеет доступ только сюда, но админ/директор/нач.произв тоже могут смотреть
    $u = require_role(['admin','director','prod_head','otk']);

    $today = date('Y-m-d');

    $date_from = $_GET['from'] ?? date('Y-m-01');
    $date_to = $_GET['to'] ?? $today;

    $location_id = (int)($_GET['location_id'] ?? 0);
    $workshop_id = (int)($_GET['workshop_id'] ?? 0);
    $part_id = (int)($_GET['part_id'] ?? 0);

    $locations = db_fetch_all(db_query("SELECT id, name FROM locations ORDER BY name"));
    if ($location_id<=0 && !empty($u['location_id'])) $location_id = (int)$u['location_id'];
    if ($location_id<=0 && count($locations)>0) $location_id = (int)$locations[0]['id'];

    $workshops = ($location_id>0)
      ? db_fetch_all(db_query("SELECT id, name FROM workshops WHERE location_id=$location_id ORDER BY name"))
      : [];

    if ($workshop_id<=0 && !empty($u['workshop_id'])) $workshop_id = (int)$u['workshop_id'];

    $parts = ($workshop_id>0)
      ? db_fetch_all(db_query("SELECT id, name FROM parts WHERE workshop_id=$workshop_id AND is_active=1 ORDER BY name"))
      : [];

    $msg = '';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        if ($u['role']!=='otk' && !in_array($u['role'], ['admin','director','prod_head'], true)) {
            http_response_code(403);
            echo "Нет доступа";
            exit;
        }

        $qc_date = trim($_POST['qc_date'] ?? $today);
        $location_id_p = (int)($_POST['location_id'] ?? 0);
        $workshop_id_p = (int)($_POST['workshop_id'] ?? 0);
        $part_id_p = (int)($_POST['part_id'] ?? 0);
        $good_qty = str_replace(',', '.', trim($_POST['good_qty'] ?? '0'));
        $bad_qty = str_replace(',', '.', trim($_POST['bad_qty'] ?? '0'));
        $comment = trim($_POST['comment'] ?? '');

        if ($location_id_p<=0 || $workshop_id_p<=0 || $part_id_p<=0) $msg='Выберите локацию, цех и деталь';
        else if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $qc_date)) $msg='Неверная дата';
        else if (!is_numeric($good_qty) || !is_numeric($bad_qty)) $msg='Количество должно быть числом';
        else {
            $good = (float)$good_qty;
            $bad = (float)$bad_qty;
            if ($good < 0 || $bad < 0) $msg='Количество не может быть отрицательным';
            else {
                $comment_esc = db_escape($comment);
                db_query("INSERT INTO qc_parts(qc_date,location_id,workshop_id,part_id,good_qty,bad_qty,comment,created_at,created_by)
                          VALUES ('".db_escape($qc_date)."',$location_id_p,$workshop_id_p,$part_id_p,$good,$bad,'$comment_esc',NOW(),".(int)$u['id'].")");
                $id = (int)db_last_id();
                audit('CREATE','qc_parts',$id,(int)$u['id'], ['date'=>$qc_date,'loc'=>$location_id_p,'ws'=>$workshop_id_p,'part'=>$part_id_p,'good'=>$good,'bad'=>$bad]);
                header("Location: index.php?m=quality&a=index&ok=1&location_id=$location_id_p&workshop_id=$workshop_id_p");
                exit;
            }
        }
    }

    $where = "q.is_deleted=0 AND q.qc_date>='".db_escape($date_from)."' AND q.qc_date<='".db_escape($date_to)."'";
    if ($location_id>0) $where .= " AND q.location_id=$location_id";
    if ($workshop_id>0) $where .= " AND q.workshop_id=$workshop_id";
    if ($part_id>0) $where .= " AND q.part_id=$part_id";

    $rows = db_fetch_all(db_query("
        SELECT q.*, l.name AS location_name, w.name AS workshop_name, p.name AS part_name, u.full_name AS user_name
        FROM qc_parts q
        JOIN locations l ON l.id=q.location_id
        JOIN workshops w ON w.id=q.workshop_id
        JOIN parts p ON p.id=q.part_id
        LEFT JOIN users u ON u.id=q.created_by
        WHERE $where
        ORDER BY q.qc_date DESC, q.id DESC
        LIMIT 500
    "));

    render('quality/index', [
        'u'=>$u,
        'msg'=>$msg,
        'ok'=>($_GET['ok'] ?? ''),
        'locations'=>$locations,
        'workshops'=>$workshops,
        'parts'=>$parts,
        'location_id'=>$location_id,
        'workshop_id'=>$workshop_id,
        'part_id'=>$part_id,
        'date_from'=>$date_from,
        'date_to'=>$date_to,
        'rows'=>$rows,
        'today'=>$today,
    ]);
}

function quality_edit() {
    $u = require_role(['admin','director','prod_head','otk']);

    $id = (int)($_GET['id'] ?? 0);
    $row = db_fetch_one(db_query("SELECT * FROM qc_parts WHERE id=$id AND is_deleted=0 LIMIT 1"));
    if (!$row) {
        http_response_code(404);
        echo "Запись не найдена";
        exit;
    }

    $locations = db_fetch_all(db_query("SELECT id, name FROM locations ORDER BY name"));
    $workshops = db_fetch_all(db_query("SELECT id, name FROM workshops WHERE location_id=".(int)$row['location_id']." ORDER BY name"));
    $parts = db_fetch_all(db_query("SELECT id, name FROM parts WHERE workshop_id=".(int)$row['workshop_id']." AND is_active=1 ORDER BY name"));

    $msg='';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $qc_date = trim($_POST['qc_date'] ?? $row['qc_date']);
        $good_qty = str_replace(',', '.', trim($_POST['good_qty'] ?? $row['good_qty']));
        $bad_qty = str_replace(',', '.', trim($_POST['bad_qty'] ?? $row['bad_qty']));
        $comment = trim($_POST['comment'] ?? '');

        if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $qc_date)) $msg='Неверная дата';
        else if (!is_numeric($good_qty) || !is_numeric($bad_qty)) $msg='Количество должно быть числом';
        else {
            $good=(float)$good_qty; $bad=(float)$bad_qty;
            if ($good<0 || $bad<0) $msg='Количество не может быть отрицательным';
            else {
                $comment_esc = db_escape($comment);
                db_query("UPDATE qc_parts SET qc_date='".db_escape($qc_date)."', good_qty=$good, bad_qty=$bad, comment='$comment_esc',
                          updated_at=NOW(), updated_by=".(int)$u['id']." WHERE id=$id");
                audit('UPDATE','qc_parts',$id,(int)$u['id'], ['date'=>$qc_date,'good'=>$good,'bad'=>$bad]);
                header("Location: index.php?m=quality&a=index&ok=1");
                exit;
            }
        }
    }

    render('quality/edit', [
        'u'=>$u,'msg'=>$msg,'row'=>$row,'locations'=>$locations,'workshops'=>$workshops,'parts'=>$parts
    ]);
}

function quality_delete() {
    $u = require_role(['admin','director','prod_head','otk']);

    $id = (int)($_POST['id'] ?? 0);
    $reason = trim($_POST['reason'] ?? '');
    if ($id<=0 || $reason==='') {
        header("Location: index.php?m=quality&a=index&err=del");
        exit;
    }

    $r = db_fetch_one(db_query("SELECT id FROM qc_parts WHERE id=$id AND is_deleted=0 LIMIT 1"));
    if (!$r) {
        header("Location: index.php?m=quality&a=index&err=notfound");
        exit;
    }

    db_query("UPDATE qc_parts SET is_deleted=1, updated_at=NOW(), updated_by=".(int)$u['id']." WHERE id=$id");
    audit('DELETE','qc_parts',$id,(int)$u['id'], ['reason'=>$reason]);
    header("Location: index.php?m=quality&a=index&ok=1");
    exit;
}
