<?php
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
require_once dirname(__DIR__, 2) . '/app/part_place.php';
require_once dirname(__DIR__, 2) . '/app/product_warehouse.php';
require_once dirname(__DIR__, 2) . '/app/audit.php';

function production_assembly() {
    $u = require_role(['admin','director','prod_head','brigadier']);

    // Цех упаковки — обычный цех. Работаем в рамках локации/цеха пользователя (для бригадира).
    $location_id = (int)($u['location_id'] ?? 0);
    $workshop_id = (int)($u['workshop_id'] ?? 0);

    if (in_array($u['role'], ['admin','director'], true)) {
        $location_id = (int)($_GET['location_id'] ?? $location_id);
        $workshop_id = (int)($_GET['workshop_id'] ?? $workshop_id);
    }

    $locations = db_fetch_all(db_query("SELECT id, name FROM locations ORDER BY name"));
    if ($location_id<=0) {
        $l = db_fetch_one(db_query("SELECT id FROM locations ORDER BY name LIMIT 1"));
        if ($l) $location_id = (int)$l['id'];
    }

    $workshops = ($location_id>0) ? db_fetch_all(db_query("SELECT id, name FROM workshops WHERE location_id=$location_id ORDER BY name")) : [];
    if ($workshop_id<=0 && count($workshops)>0) $workshop_id = (int)$workshops[0]['id'];

    $products = db_fetch_all(db_query("SELECT id, name FROM products WHERE is_active=1 ORDER BY name"));

    $product_id = (int)($_GET['product_id'] ?? 0);
    if ($product_id<=0 && count($products)>0) $product_id = (int)$products[0]['id'];

    // состав изделия
    $bom = [];
    if ($product_id>0) {
        $bom = db_fetch_all(db_query("
          SELECT pp.part_id, pp.qty_per_product, prt.name AS part_name
          FROM product_parts pp
          JOIN parts prt ON prt.id=pp.part_id
          WHERE pp.product_id=$product_id
          ORDER BY prt.name
        "));
    }

    // Откуда списываем детали: по умолчанию цех упаковки
    $source_type = $_GET['source_type'] ?? 'workshop';
    $source_type = ($source_type==='employee') ? 'employee' : 'workshop';
    $source_id = (int)($_GET['source_id'] ?? $workshop_id);

    $employees = ($location_id>0) ? db_fetch_all(db_query("SELECT id, full_name FROM employees WHERE location_id=$location_id ORDER BY full_name")) : [];

    // показываем доступность по BOM
    $avail = [];
    foreach ($bom as $b) {
        $pid = (int)$b['part_id'];
        $avail[$pid] = pp_get_balance($location_id, $source_type, $source_id, $pid);
    }

    $msg = '';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $location_id = (int)($_POST['location_id'] ?? 0);
        $workshop_id = (int)($_POST['workshop_id'] ?? 0);
        $product_id = (int)($_POST['product_id'] ?? 0);
        $qty = str_replace(',', '.', trim($_POST['qty'] ?? '0'));
        $comment = trim($_POST['comment'] ?? '');

        $source_type = $_POST['source_type'] ?? 'workshop';
        $source_type = ($source_type==='employee') ? 'employee' : 'workshop';
        $source_id = (int)($_POST['source_id'] ?? 0);

        if ($location_id<=0 || $workshop_id<=0 || $product_id<=0) $msg='Выберите локацию, цех упаковки и изделие';
        else if ($source_id<=0) $msg='Выберите источник деталей (цех или сотрудник)';
        else if (!is_numeric($qty) || (float)$qty<=0) $msg='Количество изделий должно быть больше 0';
        else {
            // BOM снова
            $bom = db_fetch_all(db_query("
              SELECT part_id, qty_per_product
              FROM product_parts
              WHERE product_id=$product_id
            "));
            if (count($bom)===0) {
                $msg='У изделия не задан состав (Настройки → Готовая продукция)';
            } else {
                $qtyf = (float)$qty;

                // Проверка остатков деталей у источника
                foreach ($bom as $b) {
                    $part_id = (int)$b['part_id'];
                    $need = (float)$b['qty_per_product'] * $qtyf;
                    $bal = pp_get_balance($location_id, $source_type, $source_id, $part_id);
                    if ($need > $bal + 1e-9) {
                        $pname = db_fetch_one(db_query("SELECT name FROM parts WHERE id=$part_id"))['name'] ?? ('ID '.$part_id);
                        $msg = "Недостаточно детали: $pname. Нужно $need, доступно $bal.";
                        break;
                    }
                }
            }

            if ($msg==='') {
                $comment_esc = db_escape($comment);

                // 1) создаём сборку
                db_query("INSERT INTO product_assemblies(location_id,workshop_id,product_id,qty,comment,created_at,created_by)
                          VALUES ($location_id,$workshop_id,$product_id,$qtyf,'$comment_esc',NOW(),".(int)$u['id'].")");
                $asm_id = (int)db_last_id();

                // 2) списываем детали у источника + записываем строки сборки
                foreach ($bom as $b) {
                    $part_id = (int)$b['part_id'];
                    $need = (float)$b['qty_per_product'] * $qtyf;
                    $ppm_out_id = pp_add_out_consume($location_id, $source_type, $source_id, $part_id, $need, $comment, (int)$u['id']);

                    db_query("INSERT INTO product_assembly_parts(assembly_id,part_id,qty,source_place_type,source_place_id,ppm_out_id)
                              VALUES ($asm_id,$part_id,$need,'$source_type',$source_id,$ppm_out_id)");
                }

                // 3) поступление готовой продукции на склад локации (product_moves: in)
                db_query("INSERT INTO product_moves(location_id,product_id,move_type,qty,reason,comment,created_at,created_by)
                          VALUES ($location_id,$product_id,'in',$qtyf,'Комплектация','$comment_esc',NOW(),".(int)$u['id'].")");
                $move_id = (int)db_last_id();

                db_query("UPDATE product_assemblies SET product_move_id=$move_id WHERE id=$asm_id");
                audit('CREATE','product_assemblies',$asm_id,(int)$u['id'], ['location_id'=>$location_id,'product_id'=>$product_id,'qty'=>$qtyf]);

                header("Location: index.php?m=production&a=assembly&location_id=$location_id&workshop_id=$workshop_id&product_id=$product_id&ok=1");
                exit;
            }
        }
    }

    // история сборок по локации (последние 50)
    $history = [];
    if ($location_id>0) {
        $history = db_fetch_all(db_query("
          SELECT a.*, p.name AS product_name, u.full_name AS user_name
          FROM product_assemblies a
          JOIN products p ON p.id=a.product_id
          LEFT JOIN users u ON u.id=a.created_by
          WHERE a.location_id=$location_id
          ORDER BY a.created_at DESC
          LIMIT 50
        "));
    }

    render('production/assembly', [
        'u'=>$u,
        'locations'=>$locations,
        'workshops'=>$workshops,
        'employees'=>$employees,
        'products'=>$products,
        'location_id'=>$location_id,
        'workshop_id'=>$workshop_id,
        'product_id'=>$product_id,
        'bom'=>$bom,
        'source_type'=>$source_type,
        'source_id'=>$source_id,
        'avail'=>$avail,
        'msg'=>$msg,
        'history'=>$history
    ]);
}
