<?php
require_once dirname(__DIR__, 2) . '/app/auth.php';
require_once dirname(__DIR__, 2) . '/app/view.php';
require_once dirname(__DIR__, 2) . '/app/db.php';
require_once dirname(__DIR__, 2) . '/app/audit.php';

function parts_index() {
    $u = require_role(['admin','director','prod_head','brigadier']);

    $location_id = (int)($_GET['location_id'] ?? 0);
    $workshop_id = (int)($_GET['workshop_id'] ?? 0);
    $q = trim($_GET['q'] ?? '');

    $locations = in_array($u['role'], ['admin','director'], true)
        ? db_fetch_all(db_query("SELECT id AS location_id, name AS location_name FROM locations ORDER BY name"))
        : get_user_locations((int)$u['id']);

    if ($location_id===0 && count($locations)===1) $location_id = (int)$locations[0]['location_id'];
    if ($location_id>0 && !in_array($u['role'], ['admin','director'], true)) require_location_access((int)$u['id'], $location_id);

    $workshops = [];
    if ($location_id>0) {
        $workshops = db_fetch_all(db_query("SELECT * FROM workshops WHERE location_id=$location_id ORDER BY name"));
    }

    $where = "p.is_active=1";
    if ($workshop_id>0) $where .= " AND p.workshop_id=$workshop_id";
    if ($q!=='') {
        $qesc = db_escape($q);
        $where .= " AND (p.name LIKE '%$qesc%' OR p.code LIKE '%$qesc%')";
    }
    if ($location_id>0) {
        $where .= " AND w.location_id=$location_id";
    }

    $rows = db_fetch_all(db_query("
      SELECT p.*, w.name AS workshop_name, l.name AS location_name
      FROM parts p
      JOIN workshops w ON w.id=p.workshop_id
      JOIN locations l ON l.id=w.location_id
      WHERE $where
      ORDER BY l.name, w.name, p.name
    "));

    render('parts/list', [
        'u'=>$u,
        'locations'=>$locations,
        'location_id'=>$location_id,
        'workshops'=>$workshops,
        'workshop_id'=>$workshop_id,
        'q'=>$q,
        'rows'=>$rows
    ]);
}

function parts_edit() {
    $u = require_role(['admin','director','prod_head']);

    $id = (int)($_GET['id'] ?? 0);

    $locations = in_array($u['role'], ['admin','director'], true)
        ? db_fetch_all(db_query("SELECT id AS location_id, name AS location_name FROM locations ORDER BY name"))
        : get_user_locations((int)$u['id']);

    $selected_location_id = 0;
    $workshops = [];
    $item = null;
    $pm = [];
    $po = [];

    if ($id>0) {
        $item = db_fetch_one(db_query("SELECT * FROM parts WHERE id=$id LIMIT 1"));
        if (!$item) { http_response_code(404); echo "Деталь не найдена"; exit; }

        $ws = db_fetch_one(db_query("SELECT * FROM workshops WHERE id=".(int)$item['workshop_id']." LIMIT 1"));
        $selected_location_id = $ws ? (int)$ws['location_id'] : 0;

        if (!in_array($u['role'], ['admin','director'], true) && $selected_location_id>0) {
            require_location_access((int)$u['id'], $selected_location_id);
        }

        if ($selected_location_id>0) {
            $workshops = db_fetch_all(db_query("SELECT * FROM workshops WHERE location_id=$selected_location_id ORDER BY name"));
        }

        $pm = db_fetch_all(db_query("
          SELECT pm.*, m.name AS material_name
          FROM part_materials pm
          JOIN materials m ON m.id=pm.material_id
          WHERE pm.part_id=$id
          ORDER BY pm.id
        "));
        $po = db_fetch_all(db_query("
          SELECT po.*, o.name AS operation_name
          FROM part_operations po
          JOIN operations o ON o.id=po.operation_id
          WHERE po.part_id=$id
          ORDER BY po.id
        "));
    }

    $materials = db_fetch_all(db_query("SELECT id, name FROM materials WHERE is_active=1 ORDER BY name"));
    $ops = db_fetch_all(db_query("
      SELECT o.id, o.name, w.name AS workshop_name, l.name AS location_name
      FROM operations o
      JOIN workshops w ON w.id=o.workshop_id
      JOIN locations l ON l.id=w.location_id
      WHERE o.is_active=1
      ORDER BY l.name, w.name, o.name
    "));

    $msg = '';
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $location_id = (int)($_POST['location_id'] ?? 0);
        $workshop_id = (int)($_POST['workshop_id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $code = trim($_POST['code'] ?? '');
        $daily_plan = (int)($_POST['daily_plan'] ?? 0);
        $qty_per_product_default = str_replace(',', '.', trim($_POST['qty_per_product_default'] ?? '1'));
        $desc = trim($_POST['description'] ?? '');
        $is_active = isset($_POST['is_active']) ? 1 : 0;

        $pm_mat = $_POST['pm_material_id'] ?? [];
        $pm_qty = $_POST['pm_qty'] ?? [];
        $po_op  = $_POST['po_operation_id'] ?? [];
        $po_qty = $_POST['po_qty'] ?? [];

        if ($location_id<=0 || $workshop_id<=0) $msg='Выберите локацию и цех';
        else if ($name==='') $msg='Название детали обязательно';
        else if (!is_numeric($qty_per_product_default) || (float)$qty_per_product_default<=0) $msg='Кол-во на изделие (по умолчанию) должно быть > 0';
        else {
            if (!in_array($u['role'], ['admin','director'], true)) {
                require_location_access((int)$u['id'], $location_id);
            }

            $name_esc = db_escape($name);
            $code_esc = db_escape($code);
            $desc_esc = db_escape($desc);
            $qpp = (float)$qty_per_product_default;

            if ($id>0) {
                db_query("UPDATE parts SET name='$name_esc', code='$code_esc', workshop_id=$workshop_id, daily_plan=$daily_plan, qty_per_product_default=$qpp, description='$desc_esc', is_active=$is_active WHERE id=$id");
                audit('UPDATE','parts',$id,(int)$u['id'], ['name'=>$name,'workshop_id'=>$workshop_id]);
                db_query("DELETE FROM part_materials WHERE part_id=$id");
                db_query("DELETE FROM part_operations WHERE part_id=$id");
            } else {
                db_query("INSERT INTO parts(name,code,workshop_id,daily_plan,qty_per_product_default,description,is_active,created_at)
                          VALUES ('$name_esc','$code_esc',$workshop_id,$daily_plan,$qpp,'$desc_esc',$is_active,NOW())");
                $id = (int)db_last_id();
                audit('CREATE','parts',$id,(int)$u['id'], ['name'=>$name,'workshop_id'=>$workshop_id]);
            }

            for ($i=0; $i<count($pm_mat); $i++) {
                $mid = (int)($pm_mat[$i] ?? 0);
                $q = str_replace(',', '.', trim($pm_qty[$i] ?? '0'));
                if ($mid<=0) continue;
                if (!is_numeric($q) || (float)$q<=0) continue;
                db_query("INSERT INTO part_materials(part_id,material_id,qty_per_part) VALUES ($id,$mid,".(float)$q.")");
            }

            for ($i=0; $i<count($po_op); $i++) {
                $oid = (int)($po_op[$i] ?? 0);
                $q = str_replace(',', '.', trim($po_qty[$i] ?? '1'));
                if ($oid<=0) continue;
                if (!is_numeric($q) || (float)$q<=0) continue;
                db_query("INSERT INTO part_operations(part_id,operation_id,qty_per_part) VALUES ($id,$oid,".(float)$q.")");
            }

            header('Location: index.php?m=parts&a=index');
            exit;
        }

        $selected_location_id = $location_id;
        $workshops = ($location_id>0) ? db_fetch_all(db_query("SELECT * FROM workshops WHERE location_id=$location_id ORDER BY name")) : [];
        $item = ['id'=>$id,'name'=>$name,'code'=>$code,'workshop_id'=>$workshop_id,'daily_plan'=>$daily_plan,'qty_per_product_default'=>$qty_per_product_default,'description'=>$desc,'is_active'=>$is_active];
    }

    render('parts/edit', [
        'u'=>$u,
        'id'=>$id,
        'item'=>$item,
        'msg'=>$msg,
        'locations'=>$locations,
        'selected_location_id'=>$selected_location_id,
        'workshops'=>$workshops,
        'materials'=>$materials,
        'ops'=>$ops,
        'pm'=>$pm,
        'po'=>$po
    ]);
}

function parts_delete() {
    $u = require_role(['admin','director']);
    $id = (int)($_GET['id'] ?? 0);
    if ($id<=0) { header('Location: index.php?m=parts&a=index'); exit; }

    db_query("DELETE FROM parts WHERE id=$id");
    audit('DELETE','parts',$id,(int)$u['id'], null);

    header('Location: index.php?m=parts&a=index');
    exit;
}
